% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulationsfunctions.R
\name{create_dist_vec}
\alias{create_dist_vec}
\title{Create vector of probabilities for a finite positive discrete distribution}
\usage{
create_dist_vec(dist, max.dist)
}
\arguments{
\item{dist}{probability mass function to use}

\item{max.dist}{maximum value at which to cutoff distribution}
}
\value{
vector of probabilites for values 1:max.dist
}
\description{
Cuts-off the (possibly unbounded) probability distribution at `max.dist`
and normalizes the resulting vector of probability to sum up to 1.
}
\examples{


geom_dist_fct(1:70)
create_dist_vec(geom_dist_fct, max.dist = 70)

}
