% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wa_data.R
\name{wa_data}
\alias{wa_data}
\alias{get_wa_pu}
\alias{get_wa_locked_in}
\alias{get_wa_locked_out}
\alias{get_wa_features}
\alias{wa_pu}
\alias{wa_locked_in}
\alias{wa_locked_out}
\title{Washington data}
\format{
\describe{
\item{get_wa_pu}{\code{\link[terra:rast]{terra::rast()}} object.}
\item{get_wa_locked_in}{\code{\link[terra:rast]{terra::rast()}} object.}
\item{get_wa_locked_out}{\code{\link[terra:rast]{terra::rast()}} object.}
\item{get_wa_features}{\code{\link[terra:rast]{terra::rast()}} object.}
}
}
\usage{
get_wa_pu()

get_wa_locked_in()

get_wa_locked_out()

get_wa_features()
}
\description{
Conservation planning dataset for Washington, The United States of America.
}
\details{
The following functions are provided to import data:

\describe{

\item{\code{get_wa_pu()}}{Import planning unit data.
The planning units are a single layer \code{\link[terra:rast]{terra::rast()}} object.
Cell values denote land acquisition costs.
These data were originally obtained from Nolte (2020 a,b).}

\item{\code{get_wa_locked_in()}}{Import locked in data.
The locked in data are a single layer \code{\link[terra:rast]{terra::rast()}} object.
Cell values denote binary values indicating if each cell
is predominantly covered by protected areas
(excluding those with no mandate for biodiversity protection).
These data were originally obtained from USGS (2022)}

\item{\code{get_wa_locked_in()}}{Import locked out data.
The locked out are a single layer \code{\link[terra:rast]{terra::rast()}} object.
Cell values denote binary values indicating if each cell
is predominantly covered by urban areas.
These data were originally obtained from the
Commission for Environmental Cooperation (2020)}

\item{\code{get_wa_features()}}{Import biodiversity feature data.
The feature data are a multi-layer
\code{\link[terra:rast]{terra::rast()}} object object.
It contains the spatial distribution of 258 bird species.
To account for migratory patterns, data are provided for the
breeding and non-breeding distributions of species
(indicated by \code{"breeding"} and \code{"non-breedig"} in the layer names).
If a species is lacking such information,
then the species is denoted with its full distribution
(as indicated \code{"full"} in the layer names).
These data were originally obtained from the eBird Status and Trends
dataset (Fink \emph{et al.} 2020).}
}
}
\examples{
# load packages
library(terra)

# import data
wa_pu <- get_wa_pu()
wa_features <- get_wa_features()
wa_locked_in <- get_wa_locked_in()
wa_locked_out <- get_wa_locked_out()

# preview planning units
print(wa_pu)
plot(wa_pu)
# preview locked in
print(wa_locked_in)
plot(wa_locked_in)

# preview locked out
print(wa_locked_out)
plot(wa_locked_out)

# preview features
print(wa_features)
plot(wa_features)

}
\references{
Commission for Environmental Cooperation. (2020). \emph{2015 Land Cover
of North America at 30 Meters}. North American Land Change Monitoring
System, 2nd Edition, \url{http://www.cec.org/north-american-environmental-atlas/land-cover-30m-2015-landsat-and-rapideye/}.

Fink D, Auer T, Johnston A, Ruiz-Gutierrez V, Hochachka WM and
Kelling S (2020) Modeling avian full annual cycle distribution and
population trends with citizen science data.
\emph{Ecological Applications}, 30: e02056.

Nolte C (2020a) \emph{Data for: High-resolution land value maps
reveal underestimation of conservation costs in the United States}.
Dryad, Dataset, \doi{10.5061/dryad.np5hqbzq9}.

Nolte C (2020b) High-resolution land value maps reveal
underestimation of conservation costs in the United States.
\emph{Proceedings of the National Academy of Sciences}, 117: 29577--29583.

U.S. Geological Survey (USGS) Gap Analysis Project (GAP) (2022)
Protected Areas Database of the United States (PAD-US) 3.0: U.S. Geological
Survey data release, \doi{10.5066/P9Q9LQ4B}.
}
\keyword{datasets}
