% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_mean_sd.R
\name{print_mean_sd}
\alias{print_mean_sd}
\title{Print mean and standard deviation}
\usage{
print_mean_sd(
  x,
  decimals_M = 2,
  decimals_SD = 2,
  parentheses = TRUE,
  short = FALSE,
  na.rm = FALSE
)
}
\arguments{
\item{x}{a vector of the sample the statistics should be printed for.}

\item{decimals_M}{how many decimals should be printed for the
mean (defaults to 2).}

\item{decimals_SD}{how many decimals should be printed for the
standard deviation (defaults to 2).}

\item{parentheses}{logical indicating if the statistics should be
wrapped in parentheses or not (defaults to
\code{TRUE}). Will be ignored if \code{short} is
\code{TRUE}.}

\item{short}{logical indicating if a short version without the letters
should be printed. Argument \code{parantheses} is ignored
in this case. Defaults to \code{FALSE}. See details.}

\item{na.rm}{logical indicating whether missing values should be
ignored or not. Defaults to \code{FALSE}.}
}
\value{
A string with information on mean and standard deviation in \code{x}.
}
\description{
Print mean and standard deviation
}
\details{
The following formatting options are available:
\itemize{
\item When \code{parentheses} is \code{TRUE}:
\eqn{(M = XX, SD = XX)}
\item When \code{parentheses} is \code{FALSE}:
\eqn{M = XX, SD = XX}
\item When \code{short} is \code{TRUE}: \eqn{XX (XX)}
}
}
\examples{

print_mean_sd(rnorm(100, 0, 1))

print_mean_sd(1:20, decimals_M = 0, decimals_SD = 3)

print_mean_sd(c(2, 10, 12.5, 3), parentheses = FALSE)

}
\author{
Juliane Nagel \email{juliane.nagel@zi-mannheim.de}
}
