% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probe-package.R
\docType{package}
\name{probe-package}
\alias{probe-package}
\alias{_PACKAGE}
\title{probe: Sparse High-Dimensional Linear Regression with PROBE}
\description{
Implements an efficient and powerful Bayesian approach for sparse high-dimensional linear regression. It uses minimal prior assumptions on the parameters through plug-in empirical Bayes estimates of hyperparameters. An efficient Parameter-Expanded Expectation-Conditional-Maximization (PX-ECM) algorithm estimates maximum a posteriori (MAP) values of regression parameters and variable selection probabilities. The PX-ECM results in a robust computationally efficient coordinate-wise optimization, which adjusts for the impact of other predictor variables. The E-step is motivated by the popular two-group approach to multiple testing. The result is a PaRtitiOned empirical Bayes Ecm (PROBE) algorithm applied to sparse high-dimensional linear regression, implemented using one-at-a-time or all-at-once type optimization. More information can be found in McLain, Zgodic, and Bondell (2022) \href{https://arxiv.org/abs/2209.08139}{arXiv:2209.08139}.
}
\details{
Examples for applying PROBE to sparse high-dimensional linear regression are given
for one-at-a-time \code{\link{probe_one}} or all-at-once \code{\link{probe}} type optimization.
}
\references{
\itemize{ \item McLain, A. C., Zgodic, A., & Bondell, H. (2022). Sparse high-dimensional linear regression with a partitioned empirical Bayes ECM algorithm. arXiv preprint arXiv:2209.08139.}
}
\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/alexmclain/PROBE/issues}
}

}
\author{
\strong{Maintainer}: Alexander McLain \email{mclaina@mailbox.sc.edu} (\href{https://orcid.org/0000-0002-5475-0670}{ORCID})

Authors:
\itemize{
  \item Anja Zodiac [contributor]
}

}
