% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPointProportion.R
\name{getPointProportion}
\alias{getPointProportion}
\title{Obtain proportion of true observations in excursion set}
\usage{
getPointProportion(pp, xBins, yBins, whichAbove, plt = FALSE)
}
\arguments{
\item{pp}{a matrix of dimension nPts x 2 with the true points locations in 2 dimensions.}

\item{xBins}{numerical vector with the ordered breaks of the grid along the x axis}

\item{yBins}{numerical vector with the ordered breaks of the grid along the y axis}

\item{whichAbove}{boolean vector of dimension nPts, selects the points above}

\item{plt}{if not \code{TRUE} plots the grid, the points and the counts for each cell.}
}
\value{
a list containing \code{above}, the counts of points in excursion, \code{full} the counts per cell of all points,
 \code{freq}, the relative frequence.
}
\description{
Computes the proportion of observations in the excursion set from true function evaluations,
 binned by the grid determined with \code{xBins}, \code{yBins}.
}
\author{
Dario Azzimonti
}
