% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpa.R
\name{mpa}
\alias{mpa}
\title{Moderated Profile Analysis}
\usage{
mpa(formula, data, moderator, k = 100, na.action = "na.fail")
}
\arguments{
\item{formula}{An object of class \code{\link{formula}} of the form \code{response ~ terms}.}

\item{data}{An optional data frame, list or environment containing the variables in the model.}

\item{moderator}{Name of the moderator variable.}

\item{k}{Corresponds to the scalar constant and must be greater than 0. Defaults to 100.}

\item{na.action}{How should missing data be handled? Function defaults to failing if missing data are present.}
}
\value{
A list containing the following components:
\itemize{
 \item \code{call} - The model call
 \item \code{output} - The output from the moderated criterion-related profile analysis
 \item \code{f.table} - The corrected F-table for assessing differences in patterns.
 \item \code{moder.model} - The standard moderated regression model
 }
}
\description{
Implements the moderated profile analysis approach developed by Davison & Davenport (unpublished)
}
\details{
The function returns the criterion-related moderated profile analysis described in Davison & Davenport (unpublished). Missing data are presently handled by specifying \code{na.action = "na.omit"}, which performs listwise deletion and \code{na.action = "na.fail"}, the default, which causes the function to fail. The following S3 generic functions are not yet available but will be in future implementations. \code{summary()},\code{anova()}, \code{print()}, and \code{plot()}. These functions provide a summary of the analysis (namely, R2 and the level and pattern components); perform ANOVA of the R2 for the pattern, the level, and the overall model; provide output similar to \code{lm()}, and plots the pattern effect. WORKS ONLY WITH TWO GROUPS!
}
\examples{
\dontrun{
data(mod_data)
mod <- mpa(gpa ~ satv * major + satq * major, moderator = "major", data = bacc2001)
summary(mod$output)
mod$f.table
summary(mod$moder.model)
}


}
\references{
Davison, M., & Davenport, E. (unpublished). Comparing Criterion-Related Patterns of Predictor Variables across Populations Using Moderated Regression.
}
\seealso{
\code{\link{cpa}}
}
\keyword{method}
