% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_good_data.R
\name{retrieve_good_data}
\alias{retrieve_good_data}
\title{Retrieve Indices of Non-Missing Data for a Specific Time Point}
\usage{
retrieve_good_data(individual_array, t, n_replicates)
}
\arguments{
\item{individual_array}{A data matrix or data frame representing individual
data, where rows correspond to time points and columns correspond to
replicates and variables.}

\item{t}{The time point for which you want to retrieve non-missing data
indices.}

\item{n_replicates}{The number of replicates in the data matrix.}
}
\value{
A numeric vector containing the indices of non-missing data values
at the specified time point \code{t}. If there are no non-missing values or
only one non-missing value, \code{NULL} is returned.
}
\description{
This function retrieves the indices of non-missing data values at a specific
time point from an individual array.
}
\examples{
# Example usage:
individual_data <- matrix(c(NA, 2, NA, 4, 5, NA), nrow = 1)
retrieve_good_data(individual_data, t = 1, n_replicates = 3)

}
\seealso{
\code{\link{which}} function for finding the indices of non-missing values.
}
\keyword{data}
\keyword{manipulation}
