% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_projoint_data.R
\name{make_projoint_data}
\alias{make_projoint_data}
\title{Make a \code{projoint_data} object from a labelled tibble}
\usage{
make_projoint_data(
  .dataframe,
  .attribute_vars,
  .id_var = "id",
  .task_var = "task",
  .profile_var = "profile",
  .selected_var = "selected",
  .selected_repeated_var = NULL,
  .fill = FALSE
)
}
\arguments{
\item{.dataframe}{A data frame (or tibble). One row per profile per task per respondent.}

\item{.attribute_vars}{Character vector of attribute column names.}

\item{.id_var}{Column name (character) with respondent IDs. Default \code{"id"}.}

\item{.task_var}{Column name (character) with task numbers. Default \code{"task"}.}

\item{.profile_var}{Column name (character) with profile numbers. Default \code{"profile"}.}

\item{.selected_var}{Column name (character) with the binary choice for each task
(values in \code{\{0,1\}}). Default \code{"selected"}.}

\item{.selected_repeated_var}{Optional column name (character) with the binary choice
for the repeated task. Default \code{NULL}.}

\item{.fill}{Logical. If \code{TRUE}, uses repeated-task agreement to \emph{fill}
missing agreement values for non-repeated tasks (assumes IRR is independent of
table content). If unsure, prefer the default \code{FALSE}.}
}
\value{
A \code{projoint_data} object (a list-like object containing a \code{labels}
  tibble and a \code{data} tibble) ready to pass to \code{\link{projoint}} and related
  functions.
}
\description{
Converts a labelled tibble/data frame (one column per attribute) into an object
of class \code{projoint_data} that downstream functions (e.g., \code{\link{projoint}})
can consume. The unit of observation should be each of two profiles in each task
for each respondent.
}
\examples{
\donttest{
# Example: build a projoint_data object from the labelled-tibble example
data(exampleData1_labelled_tibble)

att_cols <- c("School Quality", "Violent Crime Rate (Vs National Rate)",
              "Racial Composition", "Housing Cost",
              "Presidential Vote (2020)", 
              "Total Daily Driving Time for Commuting and Errands",
              "Type of Place")

pj_dat <- make_projoint_data(
  .dataframe             = exampleData1_labelled_tibble,
  .attribute_vars        = att_cols,
  .id_var                = "id",
  .task_var              = "task",
  .profile_var           = "profile",
  .selected_var          = "selected",
  .selected_repeated_var = "selected_repeated",
  .fill                  = FALSE
)

class(pj_dat)
# [1] "projoint_data"
}
}
