% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findDE.R
\name{find_dep}
\alias{find_dep}
\title{Identify differentially expressed proteins between groups}
\usage{
find_dep(
  df,
  save_output = FALSE,
  save_tophits = FALSE,
  file_path = NULL,
  adj_method = "BH",
  cutoff = 0.05,
  lfc = 1,
  n_top = 20
)
}
\arguments{
\item{df}{A \code{norm_df} object or an \code{imp_df} object.}

\item{save_output}{Logical. If \code{TRUE} saves results from the
differential expression analysis in a text file labeled "limma_output.txt"
in the directory specified by \code{file_path}.}

\item{save_tophits}{Logical. If \code{TRUE} saves \code{n_top}
number of top hits from the differential expression analysis in a text file
labeled "TopHits.txt" in the directory specified by \code{file_path}.}

\item{file_path}{A string containing the directory path to save the file.}

\item{adj_method}{Method used for adjusting the p-values for multiple
testing. Default is \code{"BH"} for "Benjamini-Hochberg" method.}

\item{cutoff}{Cutoff value for p-values and adjusted p-values. Default is
0.05.}

\item{lfc}{Minimum absolute log2-fold change to use as threshold for
differential expression.}

\item{n_top}{The number of top differentially expressed proteins to save in
the "TopHits.txt" file. Default is \code{20}.}
}
\value{
A \code{fit_df} object, which is similar to a \code{limma}
\code{fit} object.
}
\description{
This function performs differential expression analysis
on protein intensity data with limma.
}
\details{
\itemize{\item
It is important that the data is first log-transformed, ideally,
imputed, and normalized before performing differential expression analysis.
\item \code{save_output} saves the complete results table from the
differential expression analysis.
\item \code{save_tophits} first subsets the results to those with absolute
log fold change of more than 1, performs multiple correction with
the method specified in \code{adj_method} and outputs the top \code{n_top}
results based on lowest p-value and adjusted p-value.
\item If the number of hits with absolute log fold change of more than 1 is
less than \code{n_top}, \code{find_dep} prints only those with
log-fold change > 1 to "TopHits.txt".
\item If the \code{file_path} is not specified, text files will be saved in
a temporary directory.}
}
\examples{

## Perform differential expression analysis using default settings
fit_df1 <- find_dep(ecoli_norm_df)

## Change p-value and adjusted p-value cutoff
fit_df2 <- find_dep(ecoli_norm_df, cutoff = 0.1)

}
\references{
Ritchie, Matthew E., et al. "limma powers differential expression
analyses for RNA-sequencing and microarray studies." Nucleic acids research
43.7 (2015): e47-e47.
}
\seealso{
\itemize{\item\code{normalize_data}
\item\code{\link[limma:lmFit]{lmFit}},
\code{\link[limma:eBayes]{eBayes}},
\code{\link[limma:topTable]{topTable}}, and
\code{\link[limma:write.fit]{write.fit}} functions from the
\code{\link[limma]{limma}} package.}
}
\author{
Chathurani Ranathunge
}
