% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_backends.R
\name{.stan_args}
\alias{.stan_args}
\title{Gives Stan arguments the appropriate names depending on the chosen Stan backend.}
\usage{
.stan_args(model, dat, stan_init, backend, type, mcmc_samples = 0, ...)
}
\arguments{
\item{model}{Model object.}

\item{dat}{List containing data to use in fitting.}

\item{stan_init}{Function to initialize parameters for stan fit.}

\item{backend}{"rstan" or "cmdstanr".}

\item{type}{"mcmc" or "optimize".}

\item{mcmc_samples}{Integer, if greater than 0, will do full Bayesian
inference with the specified number of MCMC samples. If 0, will do MAP
estimation.}
}
\value{
Named list of arguments.
}
\description{
Gives Stan arguments the appropriate names depending on the chosen Stan backend.
}
\keyword{internal}
