#' Simulated MALDI-TOF data of equine myoglobin, labeled (with dimethylation)  and control
#'
#' This example data is loosely based on the predicted MALDI-TOF mass list of tryptic peptides of equine myoglobin, created using entry P68082 (MYG_HORSE) in UniProtKB (https://www.uniprot.org/uniprot/P68082) with further modification. Labeled peptides, either singly or doubly dimethylated, present 28 or 56 Da shfit relative to the control.
#'
#' @format a tibble dataset of 193 rows and 7 variables.
#' @docType data
#' @author Bo Yuan \email{yuanbo.faith@gmail.com}
#' \describe{
#'   \item{mass}{the mass of singly protonated peptides, in Dalton. Cysteins were alkylated with iodoacetate. }
#'   \item{position}{the positions of the N- and C-termini of peptides, counting from signal amino acid methionine. The position number of N-terminus of mature protein starts at number 2.}
#'   \item{no.MC}{number of mis-cleavages, which are cites of C-termini of lysines and arginines (without following proline)  where trypsin fail to digest apart.}
#'   \item{peptide.sequence}{the sequence of the tryptic peptides of myoglobin, composed of amino acids' single-letter abbreviations.}
#'   \item{group}{four experimental groups, consisting "label1", "label2", "label3", and "control"}
#'   \item{err}{error of the mass, in Dalton.}
#'   \item{err.ppm}{error of the mass, in parts per million (ppm) .}
#'   \item{intensity}{peak intensity, in "counts".}
#' }
#'
#' @references \url{https://www.uniprot.org/uniprot/P68082}
"myoglobin"


