/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.stream;

import com.qarks.util.Log;
import com.qarks.util.stream.CorePipedInputStream;
import com.qarks.util.stream.CorePipedOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ThreadedInputStream
extends CorePipedInputStream
implements Runnable {
    private byte[] mArray;
    private Thread mThread = null;
    private InputStream mIs;

    public ThreadedInputStream(InputStream inputStream, int n) {
        this.mIs = inputStream;
        this.mPos = new CorePipedOutputStream(2 * n);
        this.mArray = new byte[n];
        try {
            this.connect(this.mPos);
            this.mThread = new Thread(this);
            this.mThread.start();
        }
        catch (IOException iOException) {
            Log.logError(this, "cannot connect pipes.", iOException);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            this.mThread.join();
        }
        catch (InterruptedException interruptedException) {
            Log.logError(this, "join interrupted", interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int n;
            while ((n = this.mIs.read(this.mArray)) >= 0) {
                if (n > 0) {
                    this.mPos.write(this.mArray, 0, n);
                    continue;
                }
                Thread.sleep(50L);
            }
            this.mPos.close();
            this.mIs.close();
        }
        catch (Throwable throwable) {
            Log.logError(this, "cannot read.", throwable);
            throwable.printStackTrace();
        }
        finally {
            try {
                this.mPos.close();
                this.mIs.close();
            }
            catch (IOException iOException) {}
        }
    }
}

