% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subsetting}
\alias{subsetting}
\alias{[[.prt}
\alias{$.prt}
\alias{[.prt}
\title{Subsetting operations}
\usage{
\method{[[}{prt}(x, i, j, ..., exact = TRUE)

\method{$}{prt}(x, name)

\method{[}{prt}(x, i, j, drop = FALSE)
}
\arguments{
\item{x}{A \code{prt} object.}

\item{i, j}{Row/column indexes. If \code{j} is omitted, \code{i} is used as column
index.}

\item{...}{Generic compatibility: any further arguments are ignored.}

\item{exact}{Generic compatibility: only the default value of \code{TRUE} is
supported.}

\item{name}{
    a literal character string or a \link[base]{name} (possibly \link[base]{backtick}
    quoted).}

\item{drop}{Coerce to a vector if fetching one column via \code{tbl[, j]}.
Default \code{FALSE}, ignored when accessing a column via \code{tbl[j]}.}
}
\description{
Both single element subsetting via \code{[[} and \code{$}, as well as multi-element
subsetting via \code{[} are available for \code{prt} objects. Subsetting semantics
are modeled after those of the \code{tibble} class with the main difference
being that there \code{tibble} returns \code{tibble} objects, \code{prt} returns
\code{data.table}s. Differences to base R include that partial column name
matching for \code{$} is not allowed and coercion to lower dimensions for
\code{[} is always disabled by default. As \code{prt} objects are immutable, all
subset-replace functions (\verb{[[<-}, \verb{$<-} and \verb{[<-}) yield an error when
passed a \code{prt} object.
}
\examples{
dat <- as_prt(mtcars)

identical(dat$mpg, dat[["mpg"]])

dat$mp
mtcars$mp

identical(dim(dat["mpg"]), dim(mtcars["mpg"]))
identical(dim(dat[, "mpg"]), dim(mtcars[, "mpg"]))
identical(dim(dat[1L, ]), dim(mtcars[1L, ]))

}
