% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3method.R
\name{kepner_robinson_test}
\alias{kepner_robinson_test}
\alias{kepner_robinson_test.numeric}
\alias{kepner_robinson_test.formula}
\title{Kepner-Robinson Test}
\usage{
kepner_robinson_test(x, ...)

\method{kepner_robinson_test}{numeric}(
  x,
  time,
  subject,
  na.rm = FALSE,
  distribution = c("Chisq", "F"),
  ...
)

\method{kepner_robinson_test}{formula}(
  formula,
  data,
  subject,
  na.rm = FALSE,
  distribution = c("Chisq", "F"),
  ...
)
}
\arguments{
\item{x}{numeric vector containing the data}

\item{...}{further arguments are ignored}

\item{time}{factor specifying the groups}

\item{subject}{factor specifying the subjects or the name of the subject column if a data.frame is used}

\item{na.rm}{a logical value indicating if NA values should be removed}

\item{distribution}{either 'Chisq' or 'F' approximation}

\item{formula}{optional formula object}

\item{data}{optional data.frame of the data}
}
\value{
Returns an object of class 'pseudorank'
}
\description{
This function calculates the Kepner-Robinson test using ranks under the null hypothesis H0F: F_1 = ... F_k where F_i are the marginal distributions. Each subject needs to have k measurements. This test assumes that the covariance matrix of a subject has a compound symmetry structure.
}
\examples{
# create some artificial data with 20 subjects measured at two time points
data <- rnorm(40)
time <- rep(c(1,2),20)
subject <- gl(20,2)
df <- data.frame(data=data,time=time,subject=subject)

kepner_robinson_test(data,time,subject)
kepner_robinson_test(data~time,data=df,subject="subject")
}
\references{
James L. Kepner & David H. Robinson (1988) Nonparametric Methods for Detecting Treatment Effects in Repeated-Measures Designs, Journal of the American Statistical Association, 83:402, 456-461.
}
\keyword{internal}
