\name{mzchannel2pktab}
\alias{mzchannel2pktab}
\alias{pktab2mzchannel}
\title{
Conversion between peak lists from hyphenated MS (LCMS, GCMS, ...) data
and input for \code{stptw}
}
\description{Function pktab2mzchannel allows to split a list of peaks
  into several sublists, for instance on the basis of m/z values. The
  result can be aligned with \code{stptw}. The peak list can be obtained
  from packages like \code{XCMS}. The reverse function,
  mzchannel2pktab, simply gathers all peak positions in one matrix.}
\usage{
pktab2mzchannel(pktab, Ivalue = "maxo", masses = NULL, nMasses = 0, massDigits = 2)
mzchannel2pktab(mzchannels)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{pktab}{a peak table as generated for example by XCMS. Necessary
    information: m/z value (column name "mz"), retention time (column
    name "rt") and intensity.}
  \item{Ivalue}{the name of the intensity value to be used. Default is
    "maxo", one of the columns generated by the XCMS package.}
  \item{masses}{a vector of specific masses}
  \item{nMasses}{an optional number limiting the number of mass
    channels. When both \code{masses} and \code{nMasses} are defined,
    the former takes preference}
  \item{massDigits}{number of significant mass digits - if no
    \code{masses} are supplied this number determines the number of
    distinct categories in the output}
  \item{mzchannels}{a list of peak matrices, e.g. the output of
    \code{pktab2mzchannel}}
}
\value{
Function \code{pktab2mzchannel} returns a list of peak matrices; list
elements have the name of the mz value that they represent. Function
\code{mzchannel2pktab} returns one peak matrix where all masses are in a
specific column.
}
\author{Ron Wehrens}
\examples{
data(lcms)
## first couple of peaks in the first three channels
(smallset <- lapply(lcms.pks[[1]][1:3], head))
## all in one data matrix
allpeaks <- mzchannel2pktab(smallset)
## and back again
pktab2mzchannel(allpeaks, Ivalue = "I")
}
\keyword{manip}
