% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TimeSinceStart.R
\name{TimeSinceStart}
\alias{TimeSinceStart}
\title{Time Since Start}
\usage{
TimeSinceStart(data, sample = "sample",
  date.and.time = "date.and.time")
}
\arguments{
\item{data}{data frame containing at least a column giving the the time (and date) of the
measurements ordered by sample and chronologically. A column containing the sample IDs is optionally required if several samples
were measured.}

\item{sample}{optional name of the column in data containing the sample
IDs, default: "sample".}

\item{date.and.time}{optional name of the column in data containing the time (and date) as class POSIXct,
default: "date.and.time"}
}
\value{
The original data frame extended by a numerical vector containing time since start
(min) of the measurements.
}
\description{
Calculates time since start (min) of measurement for temporally repeated measurements
}
\examples{
# get example data frame
df <- leaf_drying_data

# extend df by time since start
df_with_tss <- TimeSinceStart(df)

}
