test_that("pwigls2 roda um modelo nulo simples sem erros", {
  # 1. Carregar os dados do próprio pacote
  data(dataw1)

  # 2. Rodar um modelo simples (Null Model)
  # Usamos suppressWarnings para não poluir o log se tiver avisos menores
  modelo <- suppressWarnings(
    pwigls2(Y ~ 1 + (1 | PSU), data = dataw1, wj, wi_j)
  )

  # 3. Testes: O que esperamos que aconteça?

  # Verifica se o resultado é da classe "univariate" (definida no seu pacote)
  expect_s3_class(modelo, "univariate")

  # Verifica se calculou os coeficientes (se não está vazio)
  expect_false(is.null(modelo$beta$coefficients))
})
