% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimac.R
\name{dimac}
\alias{dimac}
\title{Diversive magnetic clustering}
\usage{
dimac(sigs, id, type, loc, dist_meas = 1, gamma = 1)
}
\arguments{
\item{sigs}{A numeric matrix of fatty acid signatures in column-major
format.}

\item{id}{A character vector with a unique sample ID for each signature.}

\item{type}{A character vector of prey or predator type names.}

\item{loc}{A numeric matrix specifying the location of signatures within
\code{sig} for each \code{type}.}

\item{dist_meas}{A integer indicator of the distance measure to use. Default
value 1.}

\item{gamma}{The power parameter of the chi-square distance measure. Default
value 1.}
}
\value{
A list containing the following elements: \describe{
  \item{clust}{A data frame denoting cluster assignments at each iteration
  of the algorithm.}
  \item{clust_dist}{A numeric matrix of the summed distance within clusters
  at each iteration.}
  \item{err_code}{An integer error code(0 if no error is detected).}
  \item{err_message}{A string containing a brief summary of the results.}
}
}
\description{
The function \code{dimac} implements the \strong{di}visive
\strong{ma}gnetic \strong{c}lustering algorithm to partition fatty acid
signatures into clusters.  The DiMaC algorithm was modified from the diana
algorithm of the package cluster (Maechler et al. 2016).  \code{dimac} is
intended to be called by the user, but only after the fatty acid signatures
have been prepared for analysis by calls to the functions
\code{\link{prep_fa}} and \code{\link{prep_sig}}.  Consequently, error
checking of the arguments associated with the signatures (\code{sigs},
\code{id}, \code{type}, and \code{loc}) is necessarily limited, and
calling \code{dimac} without preceding calls to \code{\link{prep_fa}}
and \code{\link{prep_sig}} could return meaningless results.  Please see
Details or the vignette for additional information.
}
\section{Details}{

The signatures in \code{sigs} are presumed to be ready for analysis, which
is best accomplished by a call to the function \code{prep_sig}.  Please
refer to the documentation for \code{\link{prep_sig}} and/or the vignette
for additional details.

The matrix \code{loc} provides a mapping of the location of data for each
\code{type} within \code{sig}.  It must contain a row for each \code{type}
and two columns, which contain integers designating the first and last
signature of each \code{type} within \code{sigs}.  Such a matrix is returned
by the function \code{\link{prep_sig}}.

Please refer to the documentation for the function
\code{\link{dist_between_2_sigs}} for information regarding permissable
values for the arguments \code{dist_meas} and \code{gamma}.

The DiMaC algorithm is initialized with all signatures in one cluster.  The
first two magnets are chosen as the two signatures having the greatest
distance between them and each non-magnet signature is placed in the cluster
associated with the closest magnet.  The algorithm then enters an iterative
phase.  At each iteration, the cluster with the greatest average distance
between its signatures and the mean signature is identified as the "active"
cluster.  The two signatures within the active cluster having the greatest
distance between them are selected as new magnets.  One of the two new
magnets replaces the original magnet for the active cluster and the second
starts the formation of an additional cluster.  Each non-magnet signature is
placed in the cluster associated with the closest magnet, without regard for
its cluster designation in the preceding iteration.  Consequently, the
algorithm is not simply bifurcating, but rather is much more dynamic and
flexible.  The iterations continue until each signature is in its own
cluster.

Unfortunately, there is no objective method to determine the most appropriate
number of clusters for each prey or predator \code{type}.  Our suggestion is
to examine the distance results and identify any substantial reductions in
distance, which are likely caused by the discovery of structure within that
\code{type}, that are followed by a more gradual decrease in distance as the
number of clusters increases.  For diet estimation applications, partitioning
a prey library into more clusters than the number of fatty acids used to
estimate diet may result in estimates that are not unique.  In such a case,
estimates of diet composition need to be pooled into a smaller number of
"reporting groups" (e.g., Bromaghin 2008; Meynier et al. 2010).

Utility functions called by \code{dimac}:
\itemize{
\item \code{\link{dist_pairs_map}}
\item \code{\link{dist_sigs_2_mean}}
}
}

\section{References}{

Bromaghin, J.F. 2008. BELS: Backward elimination locus selection for studies
of mixture composition or individual assignment. \emph{Molecular Ecology
Resources} 8:568-571.

Maechler, M., P. Rousseeuw, A. Struyf, M. Hubert, and K. Hornik. 2016.
cluster: cluster analysis basics and extensions. R package version 2.0.4.

Meynier, L., P.C.H. morel, B.L. Chilvers, D.D.S. Mackenzie, and P. Duignan.
2010. Quantitative fatty acid signature analysis on New Zealand sea lions:
model sensitivity and diet estimates. \emph{Journal of Mammalogy}
91:1484-1495.
}

\examples{
dimac(sigs = matrix(c(0.05, 0.10, 0.30, 0.55,
                      0.04, 0.11, 0.29, 0.56,
                      0.10, 0.05, 0.35, 0.50,
                      0.12, 0.03, 0.37, 0.48,
                      0.10, 0.06, 0.35, 0.49,
                      0.05, 0.15, 0.35, 0.45), ncol=6),
      id = c("ID_1", "ID_2", "ID_3", "ID_4", "ID_5", "ID_6"),
      type = c("Type_1", "Type_2", "Type_3"),
      loc = matrix(c(1, 3, 5, 2, 4, 6), ncol=2),
      dist_meas = 1,
      gamma = NA)
dimac(sigs = matrix(c(0.05, 0.10, 0.30, 0.55,
                      0.04, 0.11, 0.29, 0.56,
                      0.10, 0.05, 0.35, 0.50,
                      0.12, 0.03, 0.37, 0.48,
                      0.10, 0.06, 0.35, 0.49,
                      0.05, 0.15, 0.35, 0.45), ncol=6),
      id = c("ID_1", "ID_2", "ID_3", "ID_4", "ID_5", "ID_6"),
      type = c("Type_1", "Type_2", "Type_3"),
      loc = matrix(c(1, 3, 5, 2, 4, 6), ncol=2),
      dist_meas = 2,
      gamma = NA)
dimac(sigs = matrix(c(0.05, 0.10, 0.30, 0.55,
                      0.04, 0.11, 0.29, 0.56,
                      0.10, 0.05, 0.35, 0.50,
                      0.12, 0.03, 0.37, 0.48,
                      0.10, 0.06, 0.35, 0.49,
                      0.05, 0.15, 0.35, 0.45), ncol=6),
      id = c("ID_1", "ID_2", "ID_3", "ID_4", "ID_5", "ID_6"),
      type = c("Type_1", "Type_2", "Type_3"),
      loc = matrix(c(1, 3, 5, 2, 4, 6), ncol=2),
      dist_meas = 3,
      gamma = 0.5)
dimac(sigs = matrix(c(0.05, 0.10, 0.30, 0.55,
                      0.04, 0.11, 0.29, 0.56,
                      0.10, 0.05, 0.35, 0.50,
                      0.12, 0.03, 0.37, 0.48,
                      0.10, 0.06, 0.35, 0.49,
                      0.05, 0.15, 0.35, 0.45), ncol=6),
      id = c("ID_1", "ID_2", "ID_3", "ID_4", "ID_5", "ID_6"),
      type = c("Type_1", "Type_2", "Type_3"),
      loc = matrix(c(1, 3, 5, 2, 4, 6), ncol=2))

}
