% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiGroupTestPower.R
\name{Multi.group.test.power}
\alias{Multi.group.test.power}
\title{Multi-group test power}
\usage{
Multi.group.test.power(
  groups,
  counts,
  control.name = NULL,
  alpha = 0.05,
  bootstrap.runs = 200,
  use.fixed.random.seed = NULL,
  CPCAT.bootstrap.runs = 200,
  Dunnett.GLM.zero.treatment.action = "log(x+1)",
  show.progress = TRUE,
  show.results = TRUE,
  test = "CPCAT"
)
}
\arguments{
\item{groups}{Group vector}

\item{counts}{Vector with count data}

\item{control.name}{Character string with control group name (optional)}

\item{alpha}{Significance level}

\item{bootstrap.runs}{Number of bootstrap runs}

\item{use.fixed.random.seed}{Use fixed seed, e.g. 123, for reproducible results. If NULL no seed is set.}

\item{CPCAT.bootstrap.runs}{Bootstrap runs within CPCAT method}

\item{Dunnett.GLM.zero.treatment.action}{GLM.Dunnett method to be used for treatments only containing zeros}

\item{show.progress}{Show progress for each shift of lambda}

\item{show.results}{Show results}

\item{test}{Either "CPCAT" or "GLM.Dunnett"}
}
\value{
Data frame with results from power analysis
}
\description{
Idea: Do parametric bootstrapping for each group and evaluate the proportion of significant results.
}
