% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqslider.R
\name{qq_vase_plot}
\alias{qq_vase_plot}
\title{Interactive QQ Vase Plot}
\usage{
qq_vase_plot(draw.samples = TRUE, dists = make_df_list(), step = 0.05,
  breaks = "FD")
}
\arguments{
\item{draw.samples}{Set to true to allow optional samples from distributions}

\item{dists}{Named list of (d=density, q=quantile, r=sample) distributions (see make_df_list())}

\item{step}{Stepsize used for animated slider (use larger values if animating with play button)}

\item{breaks}{Passed to R histogram program to control number of bins in empirical distribution}
}
\value{
None
}
\description{
This function displays animated normal quantile-quantile plots.  The software
uses Shiny to open a window in the default installed web browser. Graphical
controls in that window manipulate the construction of normal quantile plots. 
The display shows QQ plots for comparing either population distributions or 
samples of a chosen size. When samples are shown, the plot includes approximate
95% confidence bands.
}
\examples{
\dontrun{
# default
qq_vase_plot()

# suppress sampling option
qq_vase_plot(FALSE)

# add uniform distribution to dialog
dists <- make_df_list()
dists[["uniform"]] <- list(d=dunif, q=qunif, r=runif)
qq_vase_plot(TRUE, dists)

# smaller increments, change the method that determines breaks in histogram
qq_vase_plot(TRUE, step=0.01, breaks=function(x) 2*sqrt(length(x)))
}
}

