% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R
\name{coordinates}
\alias{coordinates}
\title{Extract coordinates from a QR code object.}
\usage{
coordinates(x)
}
\arguments{
\item{x}{the \code{qr_code} object.}
}
\value{
A \code{data.frame} with the \code{column} and \code{row} number of the dark
elements.
}
\description{
Selects the dark elements from the \code{qr_code} object and returns their
coordinates.
This can be useful when you want to create a QR code with a custom style.
}
\examples{
x <- qr_code("test")
plot(x)
head(coordinates(x))
plot(coordinates(x), pch = 19, cex = 2, asp = 1)
}
\seealso{
Other qr: 
\code{\link{generate_svg}()},
\code{\link{plot.qr_code}()},
\code{\link{print.qr_code}()},
\code{\link{qr_code}()},
\code{\link{qr_event}()},
\code{\link{qr_location}()},
\code{\link{qr_sepa}()},
\code{\link{qr_wifi}()}
}
\author{
Thierry Onkelinx
}
\concept{qr}
