% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qr_event.R
\name{qr_event}
\alias{qr_event}
\title{Generate a QR code for an event}
\usage{
qr_event(start, end, title, ..., ecl = c("L", "M", "Q", "H"))
}
\arguments{
\item{start}{the required start time as \code{POSIXct}.}

\item{end}{the required end time as \code{POSIXct}.}

\item{title}{the required title of the event.}

\item{...}{optional arguments as defined in the details.}

\item{ecl}{the required error correction level.
Available options are \code{"L"} (7\%), \code{"M"} (15\%), \code{"Q"} (25\%) and \code{"H"} (30\%).
Defaults to \code{"L"}.}
}
\description{
Generate a QR code for an event
}
\details{
Optional arguments.
Other arguments are silently ignored.
\itemize{
\item \code{description}
\item \code{location}
\item \code{organiser}
\item \code{url}
}
}
\seealso{
Other qr: 
\code{\link{coordinates}()},
\code{\link{generate_svg}()},
\code{\link{plot.qr_code}()},
\code{\link{print.qr_code}()},
\code{\link{qr_code}()},
\code{\link{qr_location}()},
\code{\link{qr_sepa}()},
\code{\link{qr_wifi}()}
}
\concept{qr}
