% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makedot.r
\name{makedot}
\alias{makedot}
\title{Create a General Quarto Graphviz Flow Diagram from Plain Text With Variable Insertions}
\usage{
makedot(
  .object.,
  ...,
  direction = c("TD", "LR"),
  shape = "box",
  fontsize = 24,
  nodesetup = NULL,
  file,
  width = 30,
  onlyprint = FALSE
)
}
\arguments{
\item{.object.}{character string or vector of plain text plus possible $\LaTeX$ math delimited by single dollar signs.  An empty initial line is ignore, so the user need not worry about having an initial quote mark on a line by itself.}

\item{...}{name=value pairs that makes values replace \code{{{name}}} elements in the markup}

\item{direction}{direction of the flow chart, default is top-down}

\item{shape}{node shape}

\item{fontsize}{text font size}

\item{nodesetup}{extra node setup to include after \code{direction}}

\item{file}{name of file to hold \code{graphviz} markup after variable insertions.  Run this in Quarto using a chunk to looks like what is below, which was for \code{file='graphviz.dot'}.}

\item{width}{text width for word-wrapping}

\item{onlyprint}{set to \code{TRUE} to only print the generated \code{graphiz} markup and not save it to \code{file}

\if{html}{\out{<div class="sourceCode">}}\preformatted{```\{dot\}
//| label: fig-flow1
//| fig-height: 4
//| fig-cap: "Chart caption"
//| file: graphviz.dot
```
}\if{html}{\out{</div>}}}
}
\value{
nothing; used to \code{knitr::knit_expand()} graphviz markup
}
\description{
Takes a character string or vector and creates a \code{graphviz} \code{dot} flowchart from the input.
There are two kinds of input strings or lines.  One defines nodes, the syntax being
\code{nodename:string} where \code{nodename} is any valid \code{graphviz} node name and \code{string} represents
a character string with possible variable value substitutions of the form \code{{{variablename}}}.
\code{string} is automatically wrapped by having newline characters inserted to keep lines
within \code{width} characters.  The second kind of input line is one specifying node
connections with \code{graphviz} \code{dot} syntax, respecting node names defined in earlier strings.
Unlike \code{\link[=makegvflow]{makegvflow()}}, this approach allows a node to connect to any number of other nodes,
and allows any flow direction.
}
\details{
If a node label contains \verb{\\\\n}, all \verb{\\\\n} are replaced with \verb{\\n} and ordinary word
wrapping is suppressed.  This is how users take control of line splitting.
If a node label ends in \verb{//any text}, the text in \verb{any text} will be copied
to inside the node definition after the label is closed with double quote and
after a space is added.  This allows node colors and other attributes to be changed.

Preceed single quotes in node labels with a single backslash.  Preceed double quotes with double backslashes.

The function uses \code{\link[knitr:knit_expand]{knitr::knit_expand()}} to apply variable insertions before the diagram is rendered by Quarto.  See \href{https://hbiostat.org/rflow/doverview.html#sec-doverview-filter/}{this} for an example.  ##' @title makedot
}
\examples{
x <- '
A:Some string of text for {{jj}}
B:Another string of test, this one being longer and needing breaking
C:A third string defining a node//style="filled,rounded", fillcolor=lightblue
A -> B
B -> C [label="some text along connecting arc"]
C -> A'
# Can also use A -> {B, C}
makedot(x, jj='tiger', onlyprint=TRUE)
}
\seealso{
\code{\link[=makegraphviz]{makegraphviz()}}, \code{\link[=makegvflow]{makegvflow()}}
}
\author{
Frank Harrell
}
