% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/independence_MH.R
\name{imh_pseudo}
\alias{imh_pseudo}
\title{Independence Metropolis-Hastings}
\usage{
imh_pseudo(x, log_target, pseudo)
}
\arguments{
\item{x}{The current state (scalar or numeric vector).}

\item{log_target}{A function taking a scalar or numeric vector that evaluates the log-target
density, returning a numeric scalar.}

\item{pseudo}{List specifying the pseudo-target (proposal distribution). If the list length is
equal to the number of dimensions in \code{x}, each element is itself a list that specifies
the pseudo-target for the corresponding dimension with functions \code{ld}
that evaluates the log density for that dimension,
and \code{q} that evaluates the quantile (inverse-CDF) function for that dimension.
If the dimension of \code{x} is one, then supply only the inner list
specifying the single pseudo-target.

If \code{x} is a vector but a single pseudo-target is supplied, the list must
contain a log-density function \code{ld} that accepts a vector, and a \code{r}
function that takes no arguments and generates a single multivariate draw from the
proposal distribution.}
}
\value{
A list containing the new state, \code{x}, and whether the proposed value was accepted, logical \code{accpt}.
}
\description{
Independence Metropolis-Hastings
}
\examples{
lf <- function(x) dbeta(x[1], 3, 4, log = TRUE) + dbeta(x[2], 5, 3, log = TRUE)
n_iter <- 100 # set to 1e3 for more complete illustration
draws <- matrix(0.2, nrow = n_iter, ncol = 2)
nAccpt <- 0L
pseudo <- list( list(ld = function(x) dbeta(x, 2, 2, log = TRUE),
                     q = function(u) qbeta(u, 2, 2)),
                list(ld = function(x) dbeta(x, 2, 2, log = TRUE),
                     q = function(u) qbeta(u, 2, 2))
)
for (i in seq.int(2, n_iter)) {
 out <- imh_pseudo(draws[i - 1, ], log_target = lf, pseudo = pseudo)
 draws[i,] <- out$x
 nAccpt <- nAccpt + out$accpt
 cat(i, '\r')
}
nAccpt / (nrow(draws) - 1)
plot(draws[,1], draws[,2], xlim = c(0, 1))
hist(draws[,1], freq = FALSE); curve(dbeta(x, 3, 4), col = "blue", add = TRUE)
hist(draws[,2], freq = FALSE); curve(dbeta(x, 5, 3), col = "blue", add = TRUE)
}
