% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudo_opt.R
\name{pseudo_opt}
\alias{pseudo_opt}
\title{Optimal pseudo-target for a given target}
\usage{
pseudo_opt(
  log_target = NULL,
  samples = NULL,
  type = "samples",
  family = "t",
  degf = c(1, 5, 20),
  lb = -Inf,
  ub = Inf,
  utility_type = "AUC",
  nbins = 100,
  tol_opt = 1e-06,
  tol_int = 0.001,
  plot = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{log_target}{Function to evaluate the log density of the unnormalized target.}

\item{samples}{Optional numeric vector providing samples from the target distribution
(for use as alternative to \code{log_target}).}

\item{type}{String specifying the input type. One of "function", "samples", or "grid".
Default is to use "samples".

Use of "function" requires specification of \code{log_target}.

Use of "samples" requires specification of \code{samples}.}

\item{family}{String specifying the family of distributions for the pseudo-target.
Can be any of the families accepted by \link[qslice]{pseudo_list}.}

\item{degf}{Numeric vector of degrees of freedom values to try (only if \code{family = "t"}.
Defaults to \code{c(1, 5, 20)}.}

\item{lb}{Numeric scalar giving the value of left truncation. Defaults to \code{-Inf}.}

\item{ub}{Numeric scalar giving the value of right truncation. Defaults to \code{Inf}.}

\item{utility_type}{String identifying utility type, either AUC (default) or MSW.}

\item{nbins}{Positive integer specifying the number of histogram bins if using "samples" or "grid".
Defaults to 100.}

\item{tol_opt}{Positive numeric scalar that passes to \code{reltol} in the call
to \link[stats]{optim}. Defaults to \code{1.0e-6}.}

\item{tol_int}{Positive numeric scalar that passes to \code{abs.tol} in the call to \link[stats]{integrate}.
Defaults to \code{1.0e-3}.}

\item{plot}{Logical for whether to generate two plots:
\enumerate{
\item direct comparison of the target and pseudo-target densities, and
\item transformed target density.
}

Defaults to \code{TRUE}.}

\item{verbose}{Logical for whether to print intermediate steps of optimization.
Defaults to \code{FALSE}.}
}
\value{
A list with named components:

\code{pseudo}: a list with functions corresponding to the selected pseudo-target;
output of \link[qslice]{pseudo_list}.

\code{utility}: value of the utility function using the selected pseudo-target;
output of \link[qslice]{utility_pseudo}.

\code{utility_type}: repeats the input specifying the utility type.

\code{opt}: output of \link[stats]{optim}.

Other outputs repeating inputs.
}
\description{
Find an optimal pseudo-target in a specified family to approximate
the given (unnormalized) target (Heiner et al., 2024+). Optimize over the selected utility function.
}
\details{
Optionally supply samples from the target distribution.
}
\examples{
(pseu <- pseudo_opt(samples = rnorm(1e3), type = "samples",
               family = "t", utility_type = "AUC",
               nbins = 10, plot = TRUE,
               verbose = FALSE))
oldpar <- par(mfrow = c(1,2))
(pseu <- pseudo_opt(log_target = function(x) dnorm(x, log = TRUE),
                type = "function",
                family = "logistic", utility_type = "AUC",
                nbins = 100, plot = TRUE,
                verbose = FALSE))
(pseu <- pseudo_opt(log_target = function(x) dbeta(x, 4, 2, log = TRUE),
                lb = 0, ub = 1,
                type = "function",
                family = "cauchy", utility_type = "AUC",
                nbins = 30, plot = TRUE,
                verbose = FALSE))
par(oldpar)

}
\references{
Heiner, M. J., Johnson, S. B., Christensen, J. R., and Dahl, D. B. (2024+), "Quantile Slice Sampling," \emph{arXiv preprint arXiv:###}
}
