% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDiD.R
\name{compute.MDiD}
\alias{compute.MDiD}
\title{compute.MDiD}
\usage{
compute.MDiD(
  formla,
  xformla = NULL,
  t,
  tmin1,
  tname,
  data,
  panel = FALSE,
  idname = NULL,
  uniqueid = NULL,
  probs = seq(0.05, 0.95, 0.05)
)
}
\arguments{
\item{formla}{The formula y ~ d where y is the outcome and d is the
treatment indicator (d should be binary), d should be equal to one
in all time periods for individuals that are eventually treated}

\item{xformla}{A optional one sided formula for additional covariates that
will be adjusted for.  E.g ~ age + education.  Additional covariates can
also be passed by name using the x paramater.}

\item{t}{The 3rd time period in the sample.  Treated individuals should
be treated in this time period and untreated individuals should not be
treated.  The code attempts to enforce this condition, but it is good
try to handle this outside the panel.qtet method.}

\item{tmin1}{The 2nd time period in the sample.  This should be a
pre-treatment period for all individuals in the sample.}

\item{tname}{The name of the column containing the time periods}

\item{data}{A data.frame containing all the variables used}

\item{idname}{The individual (cross-sectional unit) id name}

\item{probs}{A vector of values between 0 and 1 to compute the QTET at}
}
\description{
Internal function for computing the actual value for MDiD
}
\keyword{internal}
