% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rf.R
\name{Rf}
\alias{Rf}
\title{Retention factor (Rf)}
\usage{
Rf(object, sf = F)
}
\arguments{
\item{object}{S3 object of the working TLC}

\item{sf}{Boolean, default FALSE - Start and Front should be marked. If TRUE, Start and Front were defined.}
}
\value{
Returns S3 object with new variables. \item{object$Rf_start}{Location of the solvent start on the TLC plate} \item{object$Rf_front}{Location of the solvent end on the TLC plate} \item{object$Rf}{Rf values of the spots}
}
\description{
Calculates Rf values of the spots based on the marked start and stop of the solvent path.
}
\examples{
\dontrun{
#for more interactive variant; locate using mouse
object <- Rf(object, sf=TRUE)
}

}
\author{
Ivan D. Pavicevic, \email{ivanp84@gmail.com}
}

