% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadVAR.R
\name{quadVAR}
\alias{quadVAR}
\alias{print.quadVAR}
\alias{summary.quadVAR}
\alias{coef.quadVAR}
\alias{print.coef_quadVAR}
\alias{plot.quadVAR}
\title{Estimate lag-1 quadratic vector autoregression models}
\usage{
quadVAR(
  data,
  vars,
  dayvar = NULL,
  beepvar = NULL,
  penalty = "LASSO",
  tune = "EBIC",
  donotestimate = NULL,
  SIS_options = list(),
  RAMP_options = list()
)

\method{print}{quadVAR}(x, ...)

\method{summary}{quadVAR}(object, ...)

\method{coef}{quadVAR}(object, ...)

\method{print}{coef_quadVAR}(
  x,
  use_actual_names = TRUE,
  abbr = FALSE,
  minlength = 3,
  omit_zero = TRUE,
  digits = 2,
  row.names = FALSE,
  ...
)

\method{plot}{quadVAR}(x, value = NULL, value_standardized = TRUE, interactive = FALSE, ...)
}
\arguments{
\item{data}{A \code{tibble}, data.frame, or matrix that represents a time series of vectors, with each row as a time step.}

\item{vars}{A character vector of the variable names used in the model.}

\item{dayvar}{
String indicating assessment day. Adding this argument makes sure that the first measurement of a day is not regressed on the last measurement of the previous day. IMPORTANT: only add this if the data has multiple observations per day.
}

\item{beepvar}{
Optional string indicating assessment beep per day. Adding this argument will cause non-consecutive beeps to be treated as missing!
}

\item{penalty}{The penalty used for the linear and regularized VAR models. Possible options include "LASSO", "SCAD", "MCP", with "LASSO" as the default.}

\item{tune}{Tuning parameter selection method. Possible options include "AIC", "BIC", "EBIC", with "EBIC" as the default.}

\item{donotestimate}{A character vector of the model names that are not estimated. Possible options include, "NULL_model", "AR", "VAR", "VAR_full", "quadVAR_full", "all_others", with NULL as the default. If set "all_others", then only a \code{quadVAR} model will be estimated. For datasets with large number of variables, you may set this parameter to "quadVAR_full" to save time.}

\item{SIS_options}{A list of other parameters for the \code{\link[SIS:tune.fit]{SIS::tune.fit()}} function. This is used for the regularized  VAR models.}

\item{RAMP_options}{A list of other parameters for the \code{\link[RAMP:RAMP]{RAMP::RAMP()}} function. This is used for the nonlinear quadratic VAR model.}

\item{...}{For \code{print.quadVAR}, additional arguments passed to \code{\link[=print.coef_quadVAR]{print.coef_quadVAR()}}. For \code{print.coef_quadVAR}, additional arguments passed to \code{\link[=print.data.frame]{print.data.frame()}}.}

\item{object, x}{An \code{quadVAR} object. (For \code{print.coef_quadVAR}, an \code{coef_quadVAR} object returned by \code{\link[=coef.quadVAR]{coef.quadVAR()}}.)}

\item{use_actual_names}{Logical. If \code{TRUE}, the actual variable names are used in the output. If \code{FALSE}, the names "X1", "X2", etc., are used in the output. Default is \code{TRUE}.}

\item{abbr}{Logical. If \code{TRUE}, the output is abbreviated. Default is \code{FALSE}.}

\item{minlength}{the minimum length of the abbreviations.}

\item{omit_zero}{Logical. If \code{TRUE}, the coefficients that are zero are omitted. Default is \code{FALSE}.}

\item{digits}{the minimum number of significant digits to be used: see
    \code{\link[base]{print.default}}.}

\item{row.names}{logical (or character vector), indicating whether (or
    what) row names should be printed.}

\item{value}{A numeric vector of length 1 or the same as the number of nodes, that specifies the values of the variables that the linearized model will be based on. If the length is 1, the same value will be used for all variables. The default value is \code{NULL}, in which case the value will be set to 0 in calculation, which means (if \code{value_standardized = TRUE}) the linearized model will be based on the mean values of all variables.}

\item{value_standardized}{A logical value that specifies whether the input value is standardized or not. If TRUE, the input value will be regarded as standardized value, i.e., mean + \code{value} * sd (e.g., 0 is the mean, 1 is mean + sd, ...). If FALSE, the input value will regarded as in the raw scale of the input data. If the raw dataset was already standardized, this parameter does not have an effect. The default value is \code{TRUE}.}

\item{interactive}{Whether to produce an interactive plot using \code{shiny} (in which the user can change the values of variables interactively) or a static plot using \code{\link[qgraph:qgraph]{qgraph::qgraph()}}. Default is \code{FALSE}.}
}
\value{
An \code{quadVAR} object that contains the following elements:
\itemize{
\item \code{NULL_model}: A list of NULL models for each variable.
\item \code{AR_model}: A list of linear AR models for each variable.
\item \code{VAR_model}: A list of regularized VAR models for each variable.
\item \code{VAR_full_model}: A list of unregularized (full) VAR models for each variable.
\item \code{quadVAR_model}: A list of regularized nonlinear quadratic VAR models for each variable.
\item \code{quadVAR_full_model}: A list of unregularized (full) nonlinear quadratic VAR models for each variable.
\item \code{data},\code{vars},\code{penalty},\code{tune},\code{SIS_options},\code{RAMP_options}: The input arguments.
\item \code{data_x},\code{data_y}: The data directly used for modeling.
}
}
\description{
This function estimate regularized nonlinear quadratic vector autoregression models with strong hierarchy using the \code{\link[RAMP:RAMP]{RAMP::RAMP()}} algorithm, and also compare it with the linear AR, regularized VAR, and unregularized (full) VAR and quadratic VAR models.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(quadVAR)}: Print the coefficients for a quadVAR object. See \code{\link[=coef.quadVAR]{coef.quadVAR()}} and \code{\link[=print.coef_quadVAR]{print.coef_quadVAR()}} for details.

\item \code{summary(quadVAR)}: Summary of a quadVAR object. Different IC definitions used by different packages (which differ by a constant) are unified to make them comparable to each other.

\item \code{coef(quadVAR)}: Extract the coefficients from a quadVAR object.

\item \code{plot(quadVAR)}: Produce a plot for the linearized quadVAR model. Equivalent to first produce a linear quadVAR network using \code{\link[=linear_quadVAR_network]{linear_quadVAR_network()}}, then use \code{\link[=plot.linear_quadVAR_network]{plot.linear_quadVAR_network()}}.

}}
\section{Functions}{
\itemize{
\item \code{print(coef_quadVAR)}: Print the coefficients from a quadVAR object.

}}
\examples{
set.seed(1614)
data <- sim_4_emo(time = 200, sd = 1)
plot(data[, "x1"])
qV1 <- quadVAR(data, vars = c("x1", "x2", "x3", "x4"))
summary(qV1)
coef(qV1)
plot(qV1)
# Compare the estimation with the true model
plot(true_model_4_emo())
plot(qV1, value = 0, value_standardized = FALSE, layout = plot(true_model_4_emo())$layout)

}
\seealso{
\code{\link[=linear_quadVAR_network]{linear_quadVAR_network()}}
}
