% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_weekly_lag.R
\name{apply_weekly_lag}
\alias{apply_weekly_lag}
\title{Apply a 7 day lag to the variable \code{n_crisis}}
\usage{
apply_weekly_lag(data)
}
\arguments{
\item{data}{A data.frame with the columns \code{quadkey},
\code{day}, \code{hour} and \code{n_crisis}.}
}
\value{
A data.frame with the extra columns \code{n_crisis_lag_7} and
\code{percent_change_7}.
\itemize{
\item \code{n_crisis_lag_7}, is the same variable defined as \code{n_crisis}
in the Facebook mobility data.frame with a 7 day lag applied.
\item \code{percent_change_7} is the difference between
the \code{n_crisis} value between weeks expressed as percentage.
}
}
\description{
Applying a week lag to the data will create raster images
showing the mobility a week before the date of interest.
This function works only for QuadKeys reported without NAs for
\code{n_crisis} and \code{percent_change} variables .
}
\examples{

files <- read_fb_mobility_files(
  path_to_csvs = paste0(system.file("extdata",
    package = "quadkeyr"
  ), "/"),
  colnames = c(
    "lat",
    "lon",
    "quadkey",
    "date_time",
    "n_crisis",
    "percent_change"
  ),
  coltypes = list(
    lat = "d",
    lon = "d",
    quadkey = "c",
    date_time = "T",
    n_crisis = "c",
    percent_change = "c"
  )
)

apply_weekly_lag(data = files)
}
