% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latlong_to_qk_functions.R
\name{pixelXY_to_tileXY}
\alias{pixelXY_to_tileXY}
\title{Convert pixel XY coordinates into tile XY coordinates}
\usage{
pixelXY_to_tileXY(pixelX, pixelY)
}
\arguments{
\item{pixelX}{Pixel X coordinate.}

\item{pixelY}{Pixel Y coordinate.}
}
\value{
A list returning the tile X and tile Y coordinates.
}
\description{
Converts pixel XY coordinates into tile XY coordinates of the
tile containing the specified pixel.
For further information, refer to the Microsoft Bing Maps
Tile System documentation.
}
\details{
Converting latitude/longitude coordinates into a QuadKey
and then back to latitude/longitude won't yield identical values,
unless the initial latitude/longitude coordinates
correspond to the upper-left Quadkey's pixel and tile XY coordinates
at the same zoom level.

Understanding this distinction is crucial for
the accurate use of these functions in coordinate conversions.

For a detailed explanation on how to use this
and other similar \code{quadkeyr} functions,
read the the vignette:
\url{https://docs.ropensci.org/quadkeyr/articles/quadkey_to_sf_conversion.html}
}
\examples{

pixelXY_to_tileXY(
  pixelX = 5916,
  pixelY = 9894
)

}
\references{
\url{https://learn.microsoft.com/en-us/bingmaps/articles/bing-maps-tile-system}
}
