% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trail_compare.R
\name{trail_compare}
\alias{trail_compare}
\title{trail_compare: run a task across multiple settings and compute reliability (deprecated)}
\usage{
trail_compare(
  data,
  text_col,
  task,
  settings,
  id_col = NULL,
  label_col = "label",
  cache_dir = NULL,
  overwrite = FALSE,
  annotate_fun = annotate,
  min_coders = 2L
)
}
\arguments{
\item{data}{A data frame containing the text to be annotated.}

\item{text_col}{Character scalar. Name of the text column containing
text units to annotate.}

\item{task}{A quallmer task object describing what to extract or label.}

\item{settings}{A named list of \code{trail_setting} objects. The list
names serve as identifiers for each setting (similar to coder IDs).}

\item{id_col}{Optional character scalar identifying the unit column.
If \code{NULL}, a consistent temporary ID (\code{".trail_unit_id"}) is created
and added to the input data so annotations from all settings can be
aligned.}

\item{label_col}{Character scalar. Name of the label column in each
record's \code{annotations} data that should be used as the code for
comparison (e.g. \code{"label"}, \code{"score"}, \code{"category"}).}

\item{cache_dir}{Optional character scalar specifying a directory to
cache LLM outputs. Passed to \code{trail_record()}. If \code{NULL}, caching disabled.
For examples and tests, use \code{tempdir()} to comply with CRAN policies.}

\item{overwrite}{Logical. If \code{TRUE}, ignore all cached results and
recompute annotations for every setting.}

\item{annotate_fun}{Annotation backend function used by
\code{trail_record()}.}

\item{min_coders}{Minimum number of non-missing coders per unit
required for inclusion in the inter-rater reliability calculation.}
}
\value{
A \code{trail_compare} object with components:
\describe{
\item{records}{Named list of \code{trail_record} objects (one per setting)}
\item{matrix}{Wide coder-style annotation matrix (settings = columns)}
\item{icr}{Named list of inter-rater reliability statistics}
\item{meta}{Metadata on settings, identifiers, task, timestamp, etc.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\details{
\code{trail_compare()} is deprecated. Use \code{\link[=qlm_replicate]{qlm_replicate()}} to re-run coding with
different models or settings, then use \code{\link[=qlm_compare]{qlm_compare()}} to assess inter-rater
reliability.

All settings are applied to the same text units. Because the ID
column is shared across settings, their annotation outputs can be
directly compared via the \code{matrix} component, and summarized using
inter-rater reliability statistics in \code{icr}.
}
\seealso{
\itemize{
\item \code{trail_record()} – run a task for a single setting
\item \code{trail_matrix()} – align records into coder-style wide format
\item \code{trail_icr()} – compute inter-rater reliability across settings
}
}
\keyword{internal}
