% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{tapply2}
\alias{tapply2}
\title{Apply a Function to a (Atomic) Vector by Group}
\usage{
tapply2(.x, .grp, .sep = ".", .fun, ...)
}
\arguments{
\item{.x}{atomic vector}

\item{.grp}{list of atomic vector(s) and/or factor(s) (e.g., data.frame)
containing the groups. They should each have same length as \code{.x}. It
can also be an atomic vector or factor, which will then be made the first
element of a list internally.}

\item{.sep}{character vector of length 1 specifying the string to combine the
group values together with. \code{.sep} is only used if there are multiple
grouping variables (i.e., \code{.grp} is a list with multiple elements).}

\item{.fun}{function to apply to \code{.x} for each group.}

\item{...}{additional named arguments to pass to \code{.fun}.}
}
\value{
list of objects containing the return object of \code{.fun} for each
  group. The names are the unique combinations of the grouping variables
  (i.e., \code{unique(interaction(.grp, sep = .sep))}).
}
\description{
\code{tapply2} applies a function to a (atomic) vector by group and is an
alternative to the base R function \code{\link{tapply}}. The function is
apart of the split-apply-combine type of function discussed in the
\code{plyr} R package and is somewhat similar to \code{\link[plyr]{dlply}}.
It splits up one (atomic) vector \code{.x}into a (atomic) vector for each
group in \code{.grp}, applies a function \code{.fun} to each (atomic) vector,
and then returns the results as a list with names equal to the group values
\code{unique(interaction(.grp.nm, sep = .sep))}. \code{tapply2} is simply
\code{split.default} + \code{lapply}. Similar to \code{dlply}, The arguments
all start with \code{.} so that they do not conflict with arguments from the
function \code{.fun}. If you want to apply a function a data.frame rather
than a (atomic) vector, then use \code{\link{by2}}.
}
\examples{

# one grouping variable
tapply2(mtcars$"cyl", .grp = mtcars$"vs", .fun = median, na.rm = TRUE)

# two grouping variables
grp_nm <- c("vs","am") # Roxygen runs the whole script if I put a c() in a []
x <- tapply2(mtcars$"cyl", .grp = mtcars[grp_nm], .fun = median, na.rm = TRUE)
print(x)
str(x)

# compare to tapply
grp_nm <- c("vs","am") # Roxygen runs the whole script if I put a c() in a []
y <- tapply(mtcars$"cyl", INDEX = mtcars[grp_nm],
   FUN = median, na.rm = TRUE, simplify = FALSE)
print(y)
str(y) # has dimnames rather than names
}
\seealso{
\code{\link{tapply}}
   \code{\link{by2}}
   \code{\link[plyr]{dlply}}
}
