% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{prediction}
\alias{prediction}
\title{Predict Sentiment on New Data Using a Saved Pipeline Artifact}
\usage{
prediction(pipeline_object, df, text_column)
}
\arguments{
\item{pipeline_object}{A list object returned by the main `pipeline()` function.
It must contain the trained model, DFM template, preprocessing function,
and n-gram settings.}

\item{df}{A data frame containing the new data.}

\item{text_column}{A string specifying the column name of the text to predict.}
}
\value{
A vector of class predictions for the new data.
}
\description{
This is a generic prediction function that handles different model types
and ensures consistent preprocessing and vectorization for new, unseen text.
}
\examples{
\donttest{
if (exists("my_artifacts")) {
preds <- prediction(my_artifacts, c("cleaned text one", "cleaned text two"))
 }
}

}
