% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avg_evolution.R
\name{avg_matrix.ctqwalk}
\alias{avg_matrix.ctqwalk}
\title{The Average Mixing Matrix of a Continuous-Time Quantum Walk}
\usage{
\method{avg_matrix}{ctqwalk}(object, ...)
}
\arguments{
\item{object}{a representation of the quantum walk.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\code{avg_matrix()} returns the average mixing matrix
as a square matrix of the same order as the walk.
}
\description{
The Average Mixing Matrix of a Continuous-Time Quantum Walk
}
\details{
Let \eqn{M(t)} be the mixing matrix of the quantum walk, then the average mixing matrix is defined as

\deqn{\widehat{M} := \lim_{T \to \infty} \frac{1}{T}\int_{0}^T M(t)\textrm{d}t}

and encodes the long-term average behavior of the walk. Given the Hamiltonian
\eqn{H = \sum_r \lambda_r E_r}, it is possible to prove that

\deqn{\widehat{M} = \sum_r E_r \circ E_r}
}
\examples{
walk <- ctqwalk(matrix(c(0,1,0,1,0,1,0,1,0), nrow=3))

# Return the average mixing matrix
avg_matrix(walk)
}
\seealso{
\code{\link[=ctqwalk]{ctqwalk()}}, \code{\link[=avg_matrix]{avg_matrix()}}
}
