% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avg_evolution.R
\name{gavg_matrix.ctqwalk}
\alias{gavg_matrix.ctqwalk}
\title{The Generalized Average Mixing Matrix of a Continuous-Time Quantum Walk}
\usage{
\method{gavg_matrix}{ctqwalk}(object, R, ...)
}
\arguments{
\item{object}{a representation of the quantum walk.}

\item{R}{samples from the random variable \eqn{R} (For performance, it is recommended at most 10000 samples).}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\code{gavg_matrix()} returns the generalized average mixing matrix
as a square matrix of the same order as the walk.
}
\description{
The Generalized Average Mixing Matrix of a Continuous-Time Quantum Walk
}
\details{
Let \eqn{M(t)} be the mixing matrix of the quantum walk and \eqn{R} a random variable
with associated probability density function \eqn{f_R(t)}. Then the generalized average mixing
matrix under \eqn{R} is defined as

\deqn{\widehat{M}_R := \mathbb{E}[M(R)] = \int_{-\infty}^{\infty} M(t)f_R(t)\textrm{d}t}
}
\examples{
walk <- ctqwalk(matrix(c(0,1,0,1,0,1,0,1,0), nrow=3))

# Return the average mixing matrix under a Standard Gaussian distribution
gavg_matrix(walk, rnorm(1000))
}
\seealso{
\code{\link[=ctqwalk]{ctqwalk()}}, \code{\link[=gavg_matrix]{gavg_matrix()}}
}
