% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linalg.R
\name{get_eigschur}
\alias{get_eigschur}
\title{Extract a Schur Cross-Product from an Operator}
\usage{
get_eigschur(object, ...)
}
\arguments{
\item{object}{a representation of the operator.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A representation of the requested Schur cross-product.
}
\description{
Extract a Schur Cross-Product from an Operator
}
\examples{
s <- spectral(rbind(c(0.5, 0.3), c(0.3,0.7)))

get_eigschur(s, 1, 2) #-> get_eigschur.spectral(...)

}
\seealso{
\code{\link[=get_eigspace]{get_eigspace()}}, \code{\link[=get_eigproj]{get_eigproj()}},
\code{\link[=get_eigschur.spectral]{get_eigschur.spectral()}}
}
