% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lapply.R
\docType{data}
\name{currencyOf}
\alias{currencyOf}
\title{Fetch the currency of a country}
\format{
An object of class \code{list} of length 193.
}
\usage{
currencyOf
}
\value{
a list containing all countries and their corresponding currency
}
\description{
With specified country name or names, get the associated currency
}
\examples{
# view the searchable countries, return first 6
head(names(currencyOf))

#task 0: check if the currency of spain is included
#should be all in lower case
grep("spain",names(currencyOf), value = TRUE)

#task 1: check the currency of spain
currencyOf$spain

#task 2: check the currency of singapore list
currencyOf$singapore # return a list of singapore
currencyOf$singapore['symbol'] #returns the symbol
currencyOf$singapore['isocode'] #returns the iso code
currencyOf$singapore['fractionalunity'] #returns the fractional unit


#task 3: check currencies of multiple countries
currencyOf[c("slovenia","romania","malaysia")]

#task 4: what if the currency is not available
currencyOf[c("randomcountry","mexico","luxembourg")]

}
\keyword{datasets}
