% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2mlm.R
\name{r2mlm}
\alias{r2mlm}
\title{Compute R-squared values for multilevel models, automatically inputting
parameter estimates.}
\usage{
r2mlm(model, bargraph = TRUE)
}
\arguments{
\item{model}{A model generated using \code{\link[lme4]{lmer}} or
\code{\link[nlme]{nlme}}. Note that models using \code{lmer} must specify
random effects at the end of the model, like so: \code{outcome ~ 1 +
fixed_effects + (random_effects | cluster_variable)}. Anything else (e.g.,
\code{outcome ~ 1 + (random_effects | cluster_variable) + fixed_effects})
will not work.}

\item{bargraph}{Optional bar graph output, default is TRUE.}
}
\value{
If the input is a valid model, then the output will be a list and
  associated graphical representation of R-squared decompositions. If the
  model is not valid, it will return an error prompting the user to input a
  valid model.
}
\description{
\code{r2mlm} reads in a multilevel model (MLM) object generated using
\code{\link[lme4]{lmer}} or \code{\link[nlme]{nlme}}, and outputs all
relevant R-squared measures from the Rights and Sterba (2019) framework of
multilevel model R-squared measures, which can be visualized together as a
set using the outputted bar chart decompositions of outcome variance. That is,
when predictors are cluster-mean-centered, all R-squared measures from Rights
& Sterba (2019) Table 1 and decompositions from Rights & Sterba (2019) Figure
1 are outputted. When predictors are not cluster-mean-centered, the total
R-squared measures from Rights & Sterba (2019) Table 5, as well as bar chart
decompositions are outputted. Any number of level-1 and/or level-2 predictors
is supported. Any of the level-1 predictors can have random slopes.
}
\details{
\code{r2mlm} first determines whether a given model was generated using
\code{\link[lme4]{lmer}} or \code{\link[nlme]{nlme}}, then passes the model
to helper functions that pull the raw data and parameter estimates from the
model, and pass that information to \code{\link{r2mlm_manual}}.

Previous MLM literature has offered two perspectives on how to treat variance
attributable to random intercepts and slopes, called the “marginal” and
“conditional” approaches (e.g., Edwards et al., 2008; Orelien & Edwards,
2008; Vonesh & Chinchilli, 1997; Wang & Schaalje, 2009; Xu, 2003). In the
marginal approach, all variance attributable to predictors via random slope
variation and attributable to cluster means via random intercept variation
(i.e., sources “v” and “m”) is treated as unexplained. In the conditional
approach, variance attributable to predictors via random slope variation
and/or attributable to cluster mean variation is treated as explained. This
package offers researchers access to both the marginal and conditional
approaches. There are 5 marginal measures: f1_total, f2_total, f_total,
f1_within, and f2_between. The other 7 measures are conditional: v_total,
m_total, fv_total, fvm_total, v_within, f1v_within, and m_between.
}
\examples{
# Using lme4 for your model

# The "bobyqa" optimizer is required for this particular model to converge

model_lme4 <- lmer(satisfaction ~ 1 + salary_c + control_c + salary_m + control_m +
s_t_ratio + (1 + salary_c + control_c| schoolID), data = teachsat, REML =
TRUE, control = lmerControl(optimizer = "bobyqa"))

r2mlm(model_lme4)

# Using nlme for your model

model_nlme <- lme(satisfaction ~ 1 + salary_c + control_c + salary_m +
                  control_m + s_t_ratio,
                  random = ~ 1 + salary_c + control_c | schoolID,
                  data = teachsat,
                  method = "REML",
                  control = lmeControl(opt = "optim"))

r2mlm(model_nlme)

}
\seealso{
Rights, J. D., & Sterba, S. K. (2019). Quantifying explained
  variance in multilevel models: An integrative framework for defining
  R-squared measures. Psychological Methods, 24(3), 309–338.
  <doi:10.1037/met0000184>

Other r2mlm single model functions: 
\code{\link{r2mlm3_manual}()},
\code{\link{r2mlm_ci}()},
\code{\link{r2mlm_long_manual}()},
\code{\link{r2mlm_manual}()}
}
\concept{r2mlm single model functions}
