% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allprop.R
\name{allprop}
\alias{allprop}
\title{Lineup proportion for all lineup members}
\usage{
allprop(lineup_vec, k)
}
\arguments{
\item{lineup_vec}{A numeric vector of lineup choices}

\item{k}{Number of members in lineup. Must be specified by user (scalar).}
}
\value{
Returns a vector containing lineup proportion for each lineup member
}
\description{
Computes lineup proportion for each member in a lineup
}
\examples{
#Data:
lineup_vec <- round(runif(100, 1, 6))

#Call:
x <- allprop(lineup_vec, k = 6)
}
\references{
Wells, G. L., Leippe, M. R., & Ostrom, T. M. (1979). Guidelines for
            assessing the fairness of a lineup. \emph{Law and Human Behavior, 3}(4),
            285-293.
}
