% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_size_boot.R
\name{func_size.boot}
\alias{func_size.boot}
\title{Bootstrapped Functional Size}
\usage{
func_size.boot(lineup_vec, d = d, target_pos)
}
\arguments{
\item{lineup_vec}{A numeric vector of lineup choices}

\item{d}{Indices for bootstrap resampling}

\item{target_pos}{A scalar, representing position of target in lineup. Must be declared by user}
}
\description{
This function is a base function for the bootstrapping that ensues
to compute bootstrapped confidence intervals for the estimate of functional size
}
\details{
Function is called bootstrap resampling using boot function (in package 'boot')
        This function is never called by the user - it is called in the functional
        size master function
}
\references{
Davison,  A.C. & Hinkley,  D.V. (1997). \emph{Bootstrap methods and their
           application}. Cambridge University Press.

           Tredoux, C. G. (1998). Statistical inference on measures of lineup fairness.
           \emph{Law and Human Behavior, 22}(2), 217-237.

           Tredoux, C. (1999). Statistical considerations when determining measures of
           lineup size and lineup bias. \emph{Applied Cognitive Psychology}, 13, S9-S26.

           Wells, G. L.,Leippe, M. R., & Ostrom, T. M. (1979). Guidelines for
           empirically assessing the fairness of a lineup. \emph{Law and Human Behavior,
           3}(4), 285-293.
}
\seealso{
\code{\link[boot:boot]{boot}}: https://cran.r-project.org/web/packages/boot/boot.pdf
}
