% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{register_indicator}
\alias{register_indicator}
\title{Register an Indicator}
\usage{
register_indicator(
  indicator_id,
  domain,
  description,
  expected_inputs = character(0),
  default_thresholds = numeric(0),
  tags = character(0)
)
}
\arguments{
\item{indicator_id}{Character. Stable identifier for the indicator.}

\item{domain}{Character. One of \code{"quality"}, \code{"trace"}, \code{"risk"},
\code{"usability"}.}

\item{description}{Character. Human-readable description.}

\item{expected_inputs}{Character vector. Evidence source types this
indicator expects.}

\item{default_thresholds}{Named numeric vector. Optional thresholds.}

\item{tags}{Character vector. Optional tags (e.g., \code{"define"}, \code{"adam"}).}
}
\value{
The indicator definition list, invisibly.
}
\description{
Adds an indicator definition to the local in-memory registry.
}
\examples{
register_indicator(
  indicator_id = "P21-001",
  domain = "quality",
  description = "Required variable is missing from dataset"
)

}
