% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{evidence_pharma}
\alias{evidence_pharma}
\title{Pharma Study Evidence Table}
\format{
A tibble with 250 rows and 17 columns:
\describe{
\item{run_id}{Character. Unique run identifier.}
\item{study_id}{Character. Study identifier (CDISCPILOT01).}
\item{asset_type}{Character. Asset type: dataset, define, program, validation, spec, other.}
\item{asset_id}{Character. Asset identifier (e.g., ADSL, define.xml).}
\item{source_name}{Character. Source of the evidence (e.g., pinnacle21).}
\item{source_version}{Character. Version of the source tool.}
\item{indicator_id}{Character. Indicator identifier (e.g., Q-MISS-VAR).}
\item{indicator_name}{Character. Human-readable indicator name.}
\item{indicator_domain}{Character. Domain: quality, trace, risk, usability.}
\item{severity}{Character. Severity: info, low, medium, high, critical.}
\item{result}{Character. Result: pass, fail, warn, na.}
\item{metric_value}{Numeric. Metric value (if applicable).}
\item{metric_unit}{Character. Unit for metric_value.}
\item{message}{Character. Descriptive message.}
\item{location}{Character. Location reference (e.g., ADSL:AGE).}
\item{evidence_payload}{Character. JSON payload with additional details.}
\item{created_at}{POSIXct. Timestamp when evidence was created.}
}
}
\source{
Synthetic data based on the CDISC (Clinical Data Interchange
Standards Consortium) Pilot Study 01 structure.
}
\usage{
evidence_pharma
}
\description{
A realistic evidence table for study CDISCPILOT01 (Clinical Data
Interchange Standards Consortium Pilot Study 01) covering all four
R4SUB (R for Regulatory Submission) pillars (quality, trace, risk,
usability) with 250 rows and 18 indicators across multiple datasets
and sources.
}
\examples{
data(evidence_pharma)
head(evidence_pharma)
table(evidence_pharma$indicator_domain)
}
\keyword{datasets}
