% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.3_Factorial_designs_Functions.R
\name{contourPlot}
\alias{contourPlot}
\title{contourPlot: Contour Plot}
\usage{
contourPlot(
  x,
  y,
  z,
  data = NULL,
  xlim,
  ylim,
  main,
  xlab,
  ylab,
  form = "fit",
  col = 1,
  steps,
  fun,
  plot = TRUE,
  show.scale = TRUE
)
}
\arguments{
\item{x}{Name providing the Factor A for the plot.}

\item{y}{Name providing the Factor B for the plot.}

\item{z}{Name giving the Response variable.}

\item{data}{Needs to be an object of class \code{\link{facDesign.c}} and contains the names of x, y, z.}

\item{xlim}{Vector giving the range of the x-axis.}

\item{ylim}{Vector giving the range of the y-axis.}

\item{main}{Character string: title of the plot.}

\item{xlab}{Character string: label for the x-axis.}

\item{ylab}{Character string: label for the y-axis.}

\item{form}{A character string or a formula with the syntax `y~ x+y + x*y`. If form is a character it has to be one out of the following:
\itemize{
   \item \code{`quadratic`}
   \item \code{`full`}
   \item \code{`interaction`}
   \item \code{`linear`}
   \item \code{`fit`}
}
\code{`fit`} takes the formula from the fit in the \code{facDesign.c} object \code{fdo}. Quadratic or higher orders should be given as I(Variable^2).
By default \code{form} is set as \code{`fit`}.}

\item{col}{A predefined (1, 2, 3 or 4) or self defined colorRampPalette or color to be used (i.e. \code{`red`}).}

\item{steps}{Number of grid points per factor. By default \code{steps} = 25.}

\item{fun}{Function to be applied to z \code{desirability}.}

\item{plot}{Logical value indicating whether to display the plot. Default is \code{TRUE}.}

\item{show.scale}{Logical value indicating whether to display the color scale on the plot. Default is \code{TRUE}.}
}
\value{
The function \code{contourPlot} returns an invisible list containing:
\itemize{
 \item x - locations of grid lines for x at which the values in z are measured.
 \item y - locations of grid lines for y at which the values in z are measured.
 \item z - a matrix containing the values of z to be plotted.
 \item plot - The generated plot.
}
}
\description{
Creates a contour diagram for an object of class \code{\link{facDesign.c}}.
}
\examples{
fdo = rsmDesign(k = 3, blocks = 2)
fdo$.response(data.frame(y = rnorm(fdo$nrow())))

#I - display linear fit
contourPlot(A,B,y, data = fdo, form = "linear")
#II - display full fit (i.e. effect, interactions and quadratic effects
contourPlot(A,B,y, data = fdo, form = "full")
#III - display a fit specified before
fdo$set.fits(fdo$lm(y ~ B + I(A^2)))
contourPlot(A,B,y, data = fdo, form = "fit")
#IV - display a fit given directly
contourPlot(A,B,y, data = fdo, form = "y ~ A*B + I(A^2)")
#V - display a fit using a different colorRamp
contourPlot(A,B,y, data = fdo, form = "full", col = 2)
#VI - display a fit using a self defined colorRamp
myColour = colorRampPalette(c("green", "gray","blue"))
contourPlot(A,B,y, data = fdo, form = "full", col = myColour)
}
\seealso{
\code{\link{wirePlot}}, \code{\link{paretoChart}}
}
