% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.2_Factorial_designs_Classes.R
\name{doeFactor}
\alias{doeFactor}
\title{doeFactor-class: Class `doeFactor`}
\description{
An R6 class representing a factor in a design of experiments (DOE).
}
\seealso{
\code{\link{taguchiFactor}}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{low}}{Numeric value specifying the lower bound of the factor. Default is `-1`.}

\item{\code{high}}{Numeric value specifying the upper bound of the factor. Default is `1`.}

\item{\code{name}}{Character string specifying the name of the factor. Default is an empty string \code{``}.}

\item{\code{unit}}{Character string specifying the unit of measurement for the factor. Default is an empty string \code{``}.}

\item{\code{type}}{Character string specifying the type of the factor. Can be either \code{`numeric`} or \code{`categorical`}. Default is \code{`numeric`}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-doeFactor-attributes}{\code{doeFactor$attributes()}}
\item \href{#method-doeFactor-.low}{\code{doeFactor$.low()}}
\item \href{#method-doeFactor-.high}{\code{doeFactor$.high()}}
\item \href{#method-doeFactor-.type}{\code{doeFactor$.type()}}
\item \href{#method-doeFactor-.unit}{\code{doeFactor$.unit()}}
\item \href{#method-doeFactor-names}{\code{doeFactor$names()}}
\item \href{#method-doeFactor-print}{\code{doeFactor$print()}}
\item \href{#method-doeFactor-clone}{\code{doeFactor$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-doeFactor-attributes"></a>}}
\if{latex}{\out{\hypertarget{method-doeFactor-attributes}{}}}
\subsection{Method \code{attributes()}}{
Get the attributes of the factor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{doeFactor$attributes()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-doeFactor-.low"></a>}}
\if{latex}{\out{\hypertarget{method-doeFactor-.low}{}}}
\subsection{Method \code{.low()}}{
Get and set the lower bound for the factor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{doeFactor$.low(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Numeric value to set as the lower bound. If missing, the current lower bound is returned.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-doeFactor-.high"></a>}}
\if{latex}{\out{\hypertarget{method-doeFactor-.high}{}}}
\subsection{Method \code{.high()}}{
Get and set the upper bound for the factor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{doeFactor$.high(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Numeric value to set as the upper bound. If missing, the current upper bound is returned.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-doeFactor-.type"></a>}}
\if{latex}{\out{\hypertarget{method-doeFactor-.type}{}}}
\subsection{Method \code{.type()}}{
Get and set the type of the factor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{doeFactor$.type(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Character string specifying the type of the factor. Can be `"numeric"` or `"categorical"`. If missing, the current type is returned.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-doeFactor-.unit"></a>}}
\if{latex}{\out{\hypertarget{method-doeFactor-.unit}{}}}
\subsection{Method \code{.unit()}}{
Get and set the unit of measurement for the factor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{doeFactor$.unit(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Character string specifying the unit of measurement. If missing, the current unit is returned.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-doeFactor-names"></a>}}
\if{latex}{\out{\hypertarget{method-doeFactor-names}{}}}
\subsection{Method \code{names()}}{
Get and set the name of the factor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{doeFactor$names(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Character string specifying the name of the factor. If missing, the current name is returned.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-doeFactor-print"></a>}}
\if{latex}{\out{\hypertarget{method-doeFactor-print}{}}}
\subsection{Method \code{print()}}{
Print the characteristics of the factors.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{doeFactor$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-doeFactor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-doeFactor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{doeFactor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
