% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.3_Factorial_designs_Functions.R
\name{paretoPlot}
\alias{paretoPlot}
\title{paretoPlot}
\usage{
paretoPlot(
  dfac,
  abs = TRUE,
  decreasing = TRUE,
  alpha = 0.05,
  response = NULL,
  ylim,
  xlab,
  ylab,
  main,
  p.col,
  legend_left = TRUE
)
}
\arguments{
\item{dfac}{An object of class facDesign.}

\item{abs}{Logical. If \code{TRUE}, absolute effects and interactions are displayed. Default is \code{TRUE}.}

\item{decreasing}{Logical. If \code{TRUE}, effects and interactions are sorted decreasing. Default is \code{TRUE}.}

\item{alpha}{The significance level used to calculate the critical value}

\item{response}{Response variable. If the response data frame of fdo consists of more then one responses, this variable can be used to choose just one column of the response data frame. \code{response} needs to be an object of class character with length of `1`.
It needs to be the same character as the name of the response in the response data frame that should be plotted. By default \code{response} is set to \code{NULL}.}

\item{ylim}{Numeric vector of length 2: limits for the y-axis. If missing, the limits are set automatically.}

\item{xlab}{Character string: label for the x-axis.}

\item{ylab}{Character string: label for the y-axis.}

\item{main}{Character string: title of the plot.}

\item{p.col}{Character string specifying the color palette to use for the plot. Must be one of the following values from the \code{RColorBrewer} package:
\itemize{
  \item{\code{`Set1`}}
  \item{\code{`Set2`}}
  \item{\code{`Set3`}}
  \item{\code{`Pastel1`}}
  \item{\code{`Pastel2`}}
  \item{\code{`Paired`}}
  \item{\code{`Dark2`}}
  \item{\code{`Accent`}}
}}

\item{legend_left}{Logical value indicating whether to place the legend on the left side of the plot. Default is \code{TRUE}.}
}
\value{
The function \code{paretoPlot} returns an invisible list containing:
\item{effects}{a list of effects for each response in the \code{facDesign.c} object}
\item{plot}{The generated PP plot.}
}
\description{
Display standardized effects and interactions of a \code{\link{facDesign.c}} object in a pareto plot.
}
\details{
\code{paretoPlot} displays a pareto plot of effects and interactions for an object of class facDesign (i.e. 2^k full or 2^k-p fractional factorial design). For a given significance level alpha, a critical value is calculated and added to the plot. Standardization is achieved by dividing estimates with their standard error. For unreplicated fractional factorial designs a Lenth Plot is generated.
}
\examples{
# Create the facDesign object
dfac <- facDesign(k = 3, centerCube = 4)
dfac$names(c('Factor 1', 'Factor 2', 'Factor 3'))

# Assign performance to the factorial design
rend <- c(simProc(120,140,1), simProc(80,140,1), simProc(120,140,2),
          simProc(120,120,1), simProc(90,130,1.5), simProc(90,130,1.5),
          simProc(80,120,2), simProc(90,130,1.5), simProc(90,130,1.5),
          simProc(120,120,2), simProc(80,140,2), simProc(80,120,1))
dfac$.response(rend)

paretoPlot(dfac)
paretoPlot(dfac, decreasing = TRUE, abs = FALSE, p.col = "Pastel1")
}
\seealso{
\code{\link{fracDesign}}, \code{\link{facDesign}}
}
