% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.3_Distr_DistrCollection_Functions.R
\name{ppPlot}
\alias{ppPlot}
\title{ppPlot: Probability Plots for various distributions}
\usage{
ppPlot(
  x,
  distribution,
  confbounds = TRUE,
  alpha,
  probs,
  main,
  xlab,
  ylab,
  xlim,
  ylim,
  border = "red",
  bounds.col = "black",
  bounds.lty = 1,
  start,
  showPlot = TRUE,
  axis.y.right = FALSE,
  bw.theme = FALSE
)
}
\arguments{
\item{x}{Numeric vector containing the sample data for the \code{ppPlot}.}

\item{distribution}{Character string specifying the distribution of x. The function \code{ppPlot} will support the following character strings for \code{distribution}:
\itemize{
  \item{\code{`beta`}}
  \item{\code{`cauchy`}}
  \item{\code{`chi-squared`}}
  \item{\code{`exponential`}}
  \item{\code{`f`}}
  \item{\code{`gamma`}}
  \item{\code{`geometric`}}
  \item{\code{`log-normal`}}
  \item{\code{`lognormal`}}
  \item{\code{`logistic`}}
  \item{\code{`negative binomial`}}
  \item{\code{`normal`}}
  \item{\code{`Poisson`}}
  \item{\code{`weibull`}}
}
By default \code{distribution} is set to \code{`normal`}.}

\item{confbounds}{Logical value: whether to display confidence bounds. Default is \code{TRUE}.}

\item{alpha}{Numeric value: significance level for confidence bounds, default is `0.05`.}

\item{probs}{Vector containing the percentages for the y axis. All the values need to be between `0` and `1`.
If `probs` is missing it will be calculated internally.}

\item{main}{Character string: title of the plot.}

\item{xlab}{Character string: label for the x-axis.}

\item{ylab}{Character string: label for the y-axis.}

\item{xlim}{Numeric vector of length 2: limits for the x-axis.}

\item{ylim}{Numeric vector of length 2: limits for the y-axis.}

\item{border}{Character or numeric: color for the border of the line through the quantiles. Default is \code{`red`}.}

\item{bounds.col}{Character or numeric: color for the confidence bounds lines. Default is \code{`black`}.}

\item{bounds.lty}{Numeric or character: line type for the confidence bounds lines. This can be specified with either an integer (0-6) or a name:
\itemize{
  \item{0: blank}
  \item{1: solid}
  \item{2: dashed}
  \item{3: dotted}
  \item{4: dotdash}
  \item{5: longdash}
  \item{6: twodash}
}
Default is `1` (solid line).}

\item{start}{A named list giving the parameters to be fitted with initial values. Must be supplied for some distributions (see Details).}

\item{showPlot}{Logical value indicating whether to display the plot. By default, \code{showPlot} is set to \code{TRUE}.}

\item{axis.y.right}{Logical value indicating whether to display the y-axis on the right side. By default, \code{axis.y.right} is set to \code{FALSE}.}

\item{bw.theme}{Logical value indicating whether to use a black-and-white theme from the \code{ggplot2} package for the plot. By default, \code{bw.theme} is set to \code{FALSE}.}
}
\value{
The function \code{ppPlot} returns an invisible list containing:
\item{x}{x coordinates.}
\item{y}{y coordinates.}
\item{int}{Intercept.}
\item{slope}{Slope.}
\item{plot}{The generated PP plot.}
}
\description{
Function \code{ppPlot} creates a Probability plot of the values in x including a line.
}
\details{
Distribution fitting is performed using the \code{FitDistr} function from this package.
For the computation of the confidence bounds, the variance of the quantiles is estimated using the delta method,
which involves the estimation of the observed Fisher Information matrix as well as the gradient of the CDF of the fitted distribution.
Where possible, those values are replaced by their normal approximation.
}
\examples{
set.seed(123)
ppPlot(rnorm(20, mean=90, sd=5), "normal",alpha=0.30)
ppPlot(rcauchy(100), "cauchy")
ppPlot(rweibull(50, shape = 1, scale = 1), "weibull")
ppPlot(rlogis(50), "logistic")
ppPlot(rlnorm(50) , "log-normal")
ppPlot(rbeta(10, 0.7, 1.5),"beta")
ppPlot(rpois(20,3), "poisson")
ppPlot(rchisq(20, 10),"chi-squared")
ppPlot(rgeom(20, prob = 1/4), "geometric")
ppPlot(rnbinom(n = 20, size = 3, prob = 0.2), "negative binomial")
ppPlot(rf(20, df1 = 10, df2 = 20), "f")
}
\seealso{
\code{\link{qqPlot}}, \code{\link{FitDistr}}.
}
