% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.3_Distr_DistrCollection_Functions.R
\name{print_adtest}
\alias{print_adtest}
\title{print_adtest: Test Statistics}
\usage{
print_adtest(x, digits = 4, quote = TRUE, prefix = "", ...)
}
\arguments{
\item{x}{Needs to be an object of class \code{adtest}.}

\item{digits}{Minimal number of significant digits.}

\item{quote}{Logical, indicating whether or not strings should be printed with surrounding quotes.
By default \code{quote} is set to \code{TRUE}.}

\item{prefix}{Single character or character string that will be printed in front of \code{x}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The function returns a summary of Anderson Darling Test
}
\description{
Function to show \code{adtest}.
}
\examples{
data <- rnorm(20, mean = 20)
pcr1<-pcr(data, "normal", lsl = 17, usl = 23, plot = FALSE)
print_adtest(pcr1$adTest)
}
