% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attenuation_contamination_matrix.R
\name{attenuation_matrix}
\alias{attenuation_matrix}
\title{Create Attenuation Contamination Matrix}
\usage{
attenuation_matrix(model_output, columns, validity_coefficients, stan = FALSE)
}
\arguments{
\item{model_output}{list List of the mcmc summary and covariance matrix}

\item{columns}{vector Vector of the column names that are being assessed}

\item{validity_coefficients}{vector Vector of the validity coefficients}

\item{stan}{boolean If you are passing in a Stan backend pre-model}
}
\value{
List with the attenuation-contamination matrix and the standard
deviations
}
\description{
From the output JAGS model, create the needed attenuation
contamination matrix for further analysis. Please be aware that
this is multivariate so a minimum of 3 columns is needed.
}
\examples{
columns <- c("fruit", "veg", "tobacco")
fruit_v_coef <- generate_coefficient(100, 0.3, 0.8, 0.95)
veg_v_coef <- generate_coefficient(100, 0.25, 0.75, 0.95)
tob_v_coef <- generate_coefficient(100, 0.4, 0.7, 0.95)
validity_coefficients <- c(fruit_v_coef, veg_v_coef, tob_v_coef)
data <- data.frame(
 list(
   "BMI" = rnorm(100, mean = 0, sd = 1),
   "fruit" = rnorm(100, mean = 0, sd = 1),
   "veg" = rnorm(100, mean = 0, sd = 1),
   "tobacco" = rnorm(100, mean = 0, sd = 1)
 )
)
output <- acme_model(data, columns)
attenuation_matrix(
  output,
  columns,
  validity_coefficients,
)
}
