% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_external_object.R
\name{new_external_object}
\alias{new_external_object}
\title{Post entry to external_object table}
\usage{
new_external_object(
  doi_or_unique_name,
  primary_not_supplement = TRUE,
  release_date,
  title,
  description,
  data_product_url,
  original_store_url,
  endpoint = "http://127.0.0.1:8000/api/"
)
}
\arguments{
\item{doi_or_unique_name}{a \code{string} specifying the DOI or name of the
\code{external_object}}

\item{primary_not_supplement}{(optional) a boolean flag to indicate
whether the external object is the primary source (\code{TRUE}) or not
(\code{FALSE})}

\item{release_date}{the date-time that the \code{external_object} was
released \emph{e.g.} \code{Sys.time()} or "2010-07-11 12:15:00 BST"}

\item{title}{a \code{string} specifying the title of the \code{external_object}}

\item{description}{(optional) a \code{string} containing a free text
description of the \code{external_object}}

\item{data_product_url}{a \code{string} specifying the URL of an entry in
the \code{data_product} table}

\item{original_store_url}{(optional) a \code{string} specifying the URL of a
an entry in the \code{storage_location} table that references the original
location of an \code{external_object}}

\item{endpoint}{a \code{string} specifying the registry endpoint}
}
\description{
Upload information to the \code{external_object} table in the data registry
}
\seealso{
Other new functions: 
\code{\link{new_author}()},
\code{\link{new_code_repo_release}()},
\code{\link{new_code_run}()},
\code{\link{new_data_product}()},
\code{\link{new_file_type}()},
\code{\link{new_issue}()},
\code{\link{new_keyword}()},
\code{\link{new_licence}()},
\code{\link{new_namespace}()},
\code{\link{new_object}()},
\code{\link{new_object_component}()},
\code{\link{new_quality_controlled}()},
\code{\link{new_storage_location}()},
\code{\link{new_storage_root}()},
\code{\link{new_user_author}()}
}
\concept{new functions}
\keyword{internal}
