% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pFSA.R
\name{pFSA}
\alias{pFSA}
\title{pFSA: Pareto Feasible Solution Algorithm}
\usage{
pFSA(
  numFronts = 2,
  pselExpr = NULL,
  plot.it = TRUE,
  formula,
  data,
  fitfunc = lm,
  fixvar = NULL,
  quad = FALSE,
  m = 2,
  numrs = 1,
  cores = 1,
  interactions = T,
  criterion = AIC,
  minmax = "min",
  checkfeas = NULL,
  var4int = NULL,
  min.nonmissing = 1,
  return.models = FALSE,
  fix.formula = NULL,
  ...
)
}
\arguments{
\item{numFronts}{integer number of estimated frontiers to return}

\item{pselExpr}{expression used by function psel to estimate pareto frontiers. help(psel).}

\item{plot.it}{TRUE/FALSE for whether to plot the pareto frontiers}

\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{data}{a data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model.}

\item{fitfunc}{the method that should be used to fit the model. For Example: lm, glm, or other methods that rely on formula, data, and other inputs.}

\item{fixvar}{variable(s) to fix in the model. Usually a covariate that should always be included (Example: Age, Sex). Will still consider it with interactions. Default is NULL.}

\item{quad}{Include quadratic terms or not. Logical.}

\item{m}{order of terms to include. If interactions is set to TRUE then m is the order of interactions to be considered. For Subset selection (interaction=F), m is the size of the subset to examine. Defaults to 2.}

\item{numrs}{number of random starts to perform.}

\item{cores}{number of cores to use while running. Note: Windows can only use 1 core. See mclapply for details. If function detects a Windows user it will automatically set cores=1.}

\item{interactions}{whether to include interactions in model. Defaults to TRUE.}

\item{criterion}{which criterion function to either maximize or minimize. For linear models one can use: r.squared, adj.r.squared, cv5.lmFSA (5 Fold Cross Validation error), cv10.lmFSA (10 Fold Cross Validation error), apress (Allen's Press Statistic), int.p.val (Interaction P-value), AIC, BIC.}

\item{minmax}{whether to minimize or maximize the criterion function}

\item{checkfeas}{vector of variables that could be a feasible solution. These variables will be used as the last random start.}

\item{var4int}{specification of which variables to check for marginal feasiblilty. Default is NULL}

\item{min.nonmissing}{the combination of predictors will be ignored unless this many of observations are not missing}

\item{return.models}{bool value to specify whether return all the fitted models which have been checked}

\item{fix.formula}{...}

\item{...}{see arguments taken by function FSA or other functions. help(FSA).}
}
\value{
list of a matrix of all models obtained from FSA (fits) and their criteria. Also a matrix of the estimated frontiers that were requested. The Key column in fits, and pbound refers to the column number of the variables contined in the model fit. For instance, Key="42,96" would refer to the model which contains the variable in the 42nd column and 96th column of the designated dataset.
}
\description{
A function using a Feasible Solution Algorithm to estimate a set of models which are on the Pareto frontiers for chosen criteria
}
\examples{
\donttest{
N <- 1000 #number of obs
P <- 100 #number of variables
data <- data.frame(matrix(rnorm(N*(P+1)), nrow = N, ncol = P+1))
sln <- pFSA(formula = "X101~1", data = data, m = 2,  criterion = c(max_abs_resid,r.squared),
   minmax = c("min","max"),numrs = 10,numFronts = 2,
   pselExpr =rPref::low(max_abs_resid)*rPref::high(r.squared),plot.it = TRUE)
   }
}
